/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.valuerange.buildin.temporal;

import java.time.DateTimeException;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import org.optaplanner.core.impl.domain.valuerange.AbstractCountableValueRange;
import org.optaplanner.core.impl.domain.valuerange.util.ValueRangeIterator;
import org.optaplanner.core.impl.solver.random.RandomUtils;

public class TemporalValueRange<Temporal_ extends Temporal & Comparable<? super Temporal_>>
extends AbstractCountableValueRange<Temporal_> {
    private final Temporal_ from;
    private final Temporal_ to;
    private final long incrementUnitAmount;
    private final TemporalUnit incrementUnitType;
    private final long size;

    public TemporalValueRange(Temporal_ from, Temporal_ to, long incrementUnitAmount, TemporalUnit incrementUnitType) {
        this.from = from;
        this.to = to;
        this.incrementUnitAmount = incrementUnitAmount;
        this.incrementUnitType = incrementUnitType;
        if (from == null || to == null || incrementUnitType == null) {
            throw new IllegalArgumentException("The " + this.getClass().getSimpleName() + " must have a from (" + from + "), to (" + to + ") and incrementUnitType (" + incrementUnitType + ") that are not null.");
        }
        if (incrementUnitAmount <= 0L) {
            throw new IllegalArgumentException("The " + this.getClass().getSimpleName() + " must have strictly positive incrementUnitAmount (" + incrementUnitAmount + ").");
        }
        if (!from.isSupported(incrementUnitType) || !to.isSupported(incrementUnitType)) {
            throw new IllegalArgumentException("The " + this.getClass().getSimpleName() + " must have an incrementUnitType (" + incrementUnitType + ") that is supported by its from (" + from + ") class (" + from.getClass().getSimpleName() + ") and to (" + to + ") class (" + to.getClass().getSimpleName() + ").");
        }
        if (((Comparable)from).compareTo(to) > 0) {
            throw new IllegalArgumentException("The " + this.getClass().getSimpleName() + " cannot have a from (" + from + ") which is strictly higher than its to (" + to + ").");
        }
        long space = from.until((Temporal)to, incrementUnitType);
        Temporal expectedTo = from.plus(space, incrementUnitType);
        if (!to.equals(expectedTo)) {
            Temporal roundedExpectedTo;
            ++space;
            try {
                roundedExpectedTo = from.plus(space, incrementUnitType);
            }
            catch (DateTimeException e) {
                throw new IllegalArgumentException("The " + this.getClass().getSimpleName() + "'s incrementUnitType (" + incrementUnitType + ") must fit an integer number of times in the space (" + space + ") between from (" + from + ") and to (" + to + ").\nThe to (" + to + ") is not the expectedTo (" + expectedTo + ").", e);
            }
            if (!to.equals(roundedExpectedTo)) {
                throw new IllegalArgumentException("The " + this.getClass().getSimpleName() + "'s incrementUnitType (" + incrementUnitType + ") must fit an integer number of times in the space (" + space + ") between from (" + from + ") and to (" + to + ").\nThe to (" + to + ") is not the expectedTo (" + expectedTo + ") nor the roundedExpectedTo (" + roundedExpectedTo + ").");
            }
        }
        if (space % incrementUnitAmount > 0L) {
            throw new IllegalArgumentException("The " + this.getClass().getSimpleName() + "'s incrementUnitAmount (" + incrementUnitAmount + ") must fit an integer number of times in the space (" + space + ") between from (" + from + ") and to (" + to + ").");
        }
        this.size = space / incrementUnitAmount;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public Temporal_ get(long index) {
        if (index >= this.size || index < 0L) {
            throw new IndexOutOfBoundsException();
        }
        return (Temporal_)this.from.plus(index * this.incrementUnitAmount, this.incrementUnitType);
    }

    @Override
    public boolean contains(Temporal_ value) {
        if (value == null || !value.isSupported(this.incrementUnitType)) {
            return false;
        }
        if (((Comparable)value).compareTo(this.from) < 0 || ((Comparable)value).compareTo(this.to) >= 0) {
            return false;
        }
        long fromSpace = this.from.until((Temporal)value, this.incrementUnitType);
        if (value.equals(this.from.plus(fromSpace + 1L, this.incrementUnitType))) {
            ++fromSpace;
        }
        return fromSpace % this.incrementUnitAmount == 0L && value.equals(this.from.plus(fromSpace, this.incrementUnitType));
    }

    @Override
    public Iterator<Temporal_> createOriginalIterator() {
        return new OriginalTemporalValueRangeIterator();
    }

    @Override
    public Iterator<Temporal_> createRandomIterator(Random workingRandom) {
        return new RandomTemporalValueRangeIterator(workingRandom);
    }

    public String toString() {
        return "[" + this.from + "-" + this.to + ")";
    }

    private class RandomTemporalValueRangeIterator
    extends ValueRangeIterator<Temporal_> {
        private final Random workingRandom;

        public RandomTemporalValueRangeIterator(Random workingRandom) {
            this.workingRandom = workingRandom;
        }

        @Override
        public boolean hasNext() {
            return TemporalValueRange.this.size > 0L;
        }

        @Override
        public Temporal_ next() {
            long index = RandomUtils.nextLong(this.workingRandom, TemporalValueRange.this.size);
            return TemporalValueRange.this.get(index);
        }
    }

    private class OriginalTemporalValueRangeIterator
    extends ValueRangeIterator<Temporal_> {
        private long index = 0L;

        private OriginalTemporalValueRangeIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < TemporalValueRange.this.size;
        }

        @Override
        public Temporal_ next() {
            if (this.index >= TemporalValueRange.this.size) {
                throw new NoSuchElementException();
            }
            Object next = TemporalValueRange.this.get(this.index);
            ++this.index;
            return next;
        }
    }
}

