/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.tri;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.optaplanner.core.impl.score.stream.common.JoinerType;
import org.optaplanner.core.impl.score.stream.tri.AbstractTriJoiner;
import org.optaplanner.core.impl.score.stream.tri.SingleTriJoiner;

public final class CompositeTriJoiner<A, B, C>
extends AbstractTriJoiner<A, B, C> {
    private final List<SingleTriJoiner<A, B, C>> joinerList;
    private final JoinerType[] joinerTypes;
    private final BiFunction<A, B, ?>[] leftMappings;
    private final Function<C, ?>[] rightMappings;

    CompositeTriJoiner(List<SingleTriJoiner<A, B, C>> joinerList) {
        if (joinerList.isEmpty()) {
            throw new IllegalArgumentException("The joinerList (" + joinerList + ") must not be empty.");
        }
        this.joinerList = joinerList;
        this.joinerTypes = (JoinerType[])joinerList.stream().map(SingleTriJoiner::getJoinerType).toArray(JoinerType[]::new);
        this.leftMappings = (BiFunction[])joinerList.stream().map(SingleTriJoiner::getLeftMapping).toArray(BiFunction[]::new);
        this.rightMappings = (Function[])joinerList.stream().map(SingleTriJoiner::getRightMapping).toArray(Function[]::new);
    }

    public List<SingleTriJoiner<A, B, C>> getJoinerList() {
        return this.joinerList;
    }

    @Override
    public BiFunction<A, B, Object> getLeftMapping(int index) {
        return this.leftMappings[index];
    }

    @Override
    public BiFunction<A, B, Object[]> getLeftCombinedMapping() {
        return (a, b) -> Arrays.stream(this.leftMappings).map(f -> f.apply(a, b)).toArray();
    }

    @Override
    public JoinerType[] getJoinerTypes() {
        return this.joinerTypes;
    }

    @Override
    public Function<C, Object> getRightMapping(int index) {
        return this.rightMappings[index];
    }

    @Override
    public Function<C, Object[]> getRightCombinedMapping() {
        return c -> Arrays.stream(this.rightMappings).map(f -> f.apply(c)).toArray();
    }
}

