/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.drools.tri;

import java.util.function.Function;
import java.util.function.Supplier;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.score.stream.tri.TriConstraintCollector;
import org.optaplanner.core.impl.score.stream.drools.common.BiTuple;
import org.optaplanner.core.impl.score.stream.drools.common.DroolsAbstractUniCollectingGroupByCollectorProcessor;
import org.optaplanner.core.impl.score.stream.drools.common.TriTuple;

final class DroolsTriGroupByCollectorProcessor<A, B, C, ResultContainer, NewA, NewB, NewC>
extends DroolsAbstractUniCollectingGroupByCollectorProcessor<ResultContainer, TriTuple<A, B, C>, BiTuple<NewA, NewB>, TriTuple<NewA, NewB, NewC>> {
    private final TriFunction<A, B, C, NewA> groupKeyAMapping;
    private final TriFunction<A, B, C, NewB> groupKeyBMapping;
    private final Supplier<ResultContainer> supplier;
    private final QuadFunction<ResultContainer, A, B, C, Runnable> accumulator;
    private final Function<ResultContainer, NewC> finisher;

    public DroolsTriGroupByCollectorProcessor(TriFunction<A, B, C, NewA> groupKeyAMapping, TriFunction<A, B, C, NewB> groupKeyBMapping, TriConstraintCollector<A, B, C, ResultContainer, NewC> collector) {
        this.groupKeyAMapping = groupKeyAMapping;
        this.groupKeyBMapping = groupKeyBMapping;
        this.supplier = collector.supplier();
        this.accumulator = collector.accumulator();
        this.finisher = collector.finisher();
    }

    @Override
    protected BiTuple<NewA, NewB> toKey(TriTuple<A, B, C> abcTriTuple) {
        return new BiTuple<NewA, NewB>(this.groupKeyAMapping.apply(abcTriTuple.a, abcTriTuple.b, abcTriTuple.c), this.groupKeyBMapping.apply(abcTriTuple.a, abcTriTuple.b, abcTriTuple.c));
    }

    @Override
    protected ResultContainer newContainer() {
        return this.supplier.get();
    }

    @Override
    protected Runnable process(TriTuple<A, B, C> abcTriTuple, ResultContainer container) {
        return this.accumulator.apply(container, abcTriTuple.a, abcTriTuple.b, abcTriTuple.c);
    }

    @Override
    protected TriTuple<NewA, NewB, NewC> toResult(BiTuple<NewA, NewB> key, ResultContainer container) {
        return new TriTuple(key.a, key.b, this.finisher.apply(container));
    }
}

