/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.thread;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.heuristic.move.Move;

public class OrderByMoveIndexBlockingQueue<Solution_> {
    private final BlockingQueue<MoveResult<Solution_>> innerQueue;
    private final Map<Integer, MoveResult<Solution_>> backlog;
    private int filterStepIndex = Integer.MIN_VALUE;
    private int nextMoveIndex = Integer.MIN_VALUE;

    public OrderByMoveIndexBlockingQueue(int capacity) {
        this.innerQueue = new ArrayBlockingQueue<MoveResult<Solution_>>(capacity);
        this.backlog = new HashMap<Integer, MoveResult<Solution_>>(capacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startNextStep(int stepIndex) {
        OrderByMoveIndexBlockingQueue orderByMoveIndexBlockingQueue = this;
        synchronized (orderByMoveIndexBlockingQueue) {
            if (this.filterStepIndex >= stepIndex) {
                throw new IllegalStateException("The old filterStepIndex (" + this.filterStepIndex + ") must be less than the stepIndex (" + stepIndex + ")");
            }
            this.filterStepIndex = stepIndex;
            MoveResult exceptionResult = this.innerQueue.stream().filter(rec$ -> ((MoveResult)rec$).hasThrownException()).findFirst().orElse(null);
            if (exceptionResult != null) {
                throw new IllegalStateException("The move thread with moveThreadIndex (" + exceptionResult.getMoveThreadIndex() + ") has thrown an exception. Relayed here in the parent thread.", exceptionResult.getThrowable());
            }
            this.innerQueue.clear();
        }
        this.nextMoveIndex = 0;
        this.backlog.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUndoableMove(int moveThreadIndex, int stepIndex, int moveIndex, Move<Solution_> move) {
        MoveResult<Solution_> result = new MoveResult<Solution_>(moveThreadIndex, stepIndex, moveIndex, move, false, null);
        OrderByMoveIndexBlockingQueue orderByMoveIndexBlockingQueue = this;
        synchronized (orderByMoveIndexBlockingQueue) {
            if (result.getStepIndex() != this.filterStepIndex) {
                return;
            }
            this.innerQueue.add(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMove(int moveThreadIndex, int stepIndex, int moveIndex, Move<Solution_> move, Score score) {
        MoveResult<Solution_> result = new MoveResult<Solution_>(moveThreadIndex, stepIndex, moveIndex, move, true, score);
        OrderByMoveIndexBlockingQueue orderByMoveIndexBlockingQueue = this;
        synchronized (orderByMoveIndexBlockingQueue) {
            if (result.getStepIndex() != this.filterStepIndex) {
                return;
            }
            this.innerQueue.add(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExceptionThrown(int moveThreadIndex, Throwable throwable) {
        MoveResult result = new MoveResult(moveThreadIndex, throwable);
        OrderByMoveIndexBlockingQueue orderByMoveIndexBlockingQueue = this;
        synchronized (orderByMoveIndexBlockingQueue) {
            this.innerQueue.add(result);
        }
    }

    public MoveResult<Solution_> take() throws InterruptedException {
        MoveResult<Solution_> result;
        int moveIndex = this.nextMoveIndex++;
        if (!this.backlog.isEmpty() && (result = this.backlog.remove(moveIndex)) != null) {
            return result;
        }
        while (true) {
            if (((MoveResult)(result = this.innerQueue.take())).hasThrownException()) {
                throw new IllegalStateException("The move thread with moveThreadIndex (" + result.getMoveThreadIndex() + ") has thrown an exception. Relayed here in the parent thread.", ((MoveResult)result).getThrowable());
            }
            if (result.getMoveIndex() == moveIndex) {
                return result;
            }
            this.backlog.put(result.getMoveIndex(), result);
        }
    }

    public static class MoveResult<Solution_> {
        private final int moveThreadIndex;
        private final int stepIndex;
        private final int moveIndex;
        private final Move<Solution_> move;
        private final boolean moveDoable;
        private final Score score;
        private final Throwable throwable;

        public MoveResult(int moveThreadIndex, int stepIndex, int moveIndex, Move<Solution_> move, boolean moveDoable, Score score) {
            this.moveThreadIndex = moveThreadIndex;
            this.stepIndex = stepIndex;
            this.moveIndex = moveIndex;
            this.move = move;
            this.moveDoable = moveDoable;
            this.score = score;
            this.throwable = null;
        }

        public MoveResult(int moveThreadIndex, Throwable throwable) {
            this.moveThreadIndex = moveThreadIndex;
            this.stepIndex = -1;
            this.moveIndex = -1;
            this.move = null;
            this.moveDoable = false;
            this.score = null;
            this.throwable = throwable;
        }

        private boolean hasThrownException() {
            return this.throwable != null;
        }

        public int getMoveThreadIndex() {
            return this.moveThreadIndex;
        }

        public int getStepIndex() {
            return this.stepIndex;
        }

        public int getMoveIndex() {
            return this.moveIndex;
        }

        public Move<Solution_> getMove() {
            return this.move;
        }

        public boolean isMoveDoable() {
            return this.moveDoable;
        }

        public Score getScore() {
            return this.score;
        }

        private Throwable getThrowable() {
            return this.throwable;
        }
    }
}

