/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.list.nearby;

import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.index.IndexVariableDemand;
import org.optaplanner.core.impl.domain.variable.index.IndexVariableSupply;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonListInverseVariableDemand;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.AbstractNearbySelector;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyRandom;
import org.optaplanner.core.impl.heuristic.selector.list.DestinationSelector;
import org.optaplanner.core.impl.heuristic.selector.list.ElementDestinationSelector;
import org.optaplanner.core.impl.heuristic.selector.list.ElementRef;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListener;
import org.optaplanner.core.impl.solver.scope.SolverScope;

abstract class AbstractNearbyDestinationSelector<Solution_, ReplayingSelector_ extends PhaseLifecycleListener<Solution_>>
extends AbstractNearbySelector<Solution_, ElementDestinationSelector<Solution_>, ReplayingSelector_>
implements DestinationSelector<Solution_> {
    protected SingletonInverseVariableSupply inverseVariableSupply;
    protected IndexVariableSupply indexVariableSupply;

    public AbstractNearbyDestinationSelector(ElementDestinationSelector<Solution_> childDestinationSelector, Object originSubListSelector, NearbyDistanceMeter<?, ?> nearbyDistanceMeter, NearbyRandom nearbyRandom, boolean randomSelection) {
        super(childDestinationSelector, originSubListSelector, nearbyDistanceMeter, nearbyRandom, randomSelection);
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        SupplyManager supplyManager = solverScope.getScoreDirector().getSupplyManager();
        ListVariableDescriptor listVariableDescriptor = ((ElementDestinationSelector)this.childSelector).getVariableDescriptor();
        this.inverseVariableSupply = supplyManager.demand(new SingletonListInverseVariableDemand(listVariableDescriptor));
        this.indexVariableSupply = supplyManager.demand(new IndexVariableDemand(listVariableDescriptor));
    }

    protected int computeDestinationSize() {
        int overallSizeMaximum;
        long childSize = ((ElementDestinationSelector)this.childSelector).getSize();
        if (childSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The childDestinationSelector (" + this.childSelector + ") has a destinationSize (" + childSize + ") which is higher than Integer.MAX_VALUE.");
        }
        int destinationSize = (int)childSize;
        if (this.randomSelection && destinationSize > (overallSizeMaximum = this.nearbyRandom.getOverallSizeMaximum())) {
            destinationSize = overallSizeMaximum;
        }
        return destinationSize;
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        this.inverseVariableSupply = null;
        this.indexVariableSupply = null;
    }

    @Override
    public boolean isCountable() {
        return ((ElementDestinationSelector)this.childSelector).isCountable();
    }

    @Override
    public long getSize() {
        return ((ElementDestinationSelector)this.childSelector).getSize();
    }

    protected ElementRef elementRef(Object next) {
        if (((ElementDestinationSelector)this.childSelector).getEntityDescriptor().matchesEntity(next)) {
            return ElementRef.of(next, 0);
        }
        return ElementRef.of(this.inverseVariableSupply.getInverseSingleton(next), this.indexVariableSupply.getIndex(next) + 1);
    }
}

