/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.listener.support;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.optaplanner.core.api.domain.variable.AbstractVariableListener;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.listener.SourcedVariableListener;
import org.optaplanner.core.impl.domain.variable.listener.VariableListenerWithSources;
import org.optaplanner.core.impl.domain.variable.listener.support.AbstractNotifiable;
import org.optaplanner.core.impl.domain.variable.listener.support.BasicVariableNotification;
import org.optaplanner.core.impl.domain.variable.listener.support.EntityNotifiable;
import org.optaplanner.core.impl.domain.variable.listener.support.EntityNotification;
import org.optaplanner.core.impl.domain.variable.listener.support.ListVariableListenerNotifiable;
import org.optaplanner.core.impl.domain.variable.listener.support.ListVariableNotification;
import org.optaplanner.core.impl.domain.variable.listener.support.Notifiable;
import org.optaplanner.core.impl.domain.variable.listener.support.NotifiableRegistry;
import org.optaplanner.core.impl.domain.variable.listener.support.Notification;
import org.optaplanner.core.impl.domain.variable.listener.support.VariableListenerNotifiable;
import org.optaplanner.core.impl.domain.variable.listener.support.violation.ShadowVariablesAssert;
import org.optaplanner.core.impl.domain.variable.supply.Demand;
import org.optaplanner.core.impl.domain.variable.supply.Supply;
import org.optaplanner.core.impl.domain.variable.supply.SupplyManager;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;

public final class VariableListenerSupport<Solution_>
implements SupplyManager {
    private final InnerScoreDirector<Solution_, ?> scoreDirector;
    private final NotifiableRegistry<Solution_> notifiableRegistry;
    private final Map<Demand<?>, Supply> supplyMap = new LinkedHashMap();
    private final Map<Demand<?>, Long> demandCounterMap = new HashMap();
    private boolean notificationQueuesAreEmpty = true;
    private int nextGlobalOrder = 0;

    public static <Solution_> VariableListenerSupport<Solution_> create(InnerScoreDirector<Solution_, ?> scoreDirector) {
        return new VariableListenerSupport<Solution_>(scoreDirector, new NotifiableRegistry<Solution_>(scoreDirector.getSolutionDescriptor()));
    }

    VariableListenerSupport(InnerScoreDirector<Solution_, ?> scoreDirector, NotifiableRegistry<Solution_> notifiableRegistry) {
        this.scoreDirector = scoreDirector;
        this.notifiableRegistry = notifiableRegistry;
    }

    public void linkVariableListeners() {
        this.scoreDirector.getSolutionDescriptor().getEntityDescriptors().stream().map(EntityDescriptor::getDeclaredShadowVariableDescriptors).flatMap(Collection::stream).filter(ShadowVariableDescriptor::hasVariableListener).sorted(Comparator.comparingInt(ShadowVariableDescriptor::getGlobalShadowOrder)).forEach(this::processShadowVariableDescriptor);
    }

    private void processShadowVariableDescriptor(ShadowVariableDescriptor<Solution_> shadowVariableDescriptor) {
        for (VariableListenerWithSources<Solution_> listenerWithSources : shadowVariableDescriptor.buildVariableListeners(this)) {
            AbstractVariableListener<Solution_, Object> variableListener = listenerWithSources.getVariableListener();
            if (variableListener instanceof Supply) {
                Demand<?> demand = shadowVariableDescriptor.getProvidedDemand();
                this.supplyMap.put(demand, (Supply)((Object)variableListener));
                this.demandCounterMap.put(demand, 1L);
            }
            int globalOrder = shadowVariableDescriptor.getGlobalShadowOrder();
            this.notifiableRegistry.registerNotifiable(listenerWithSources.getSourceVariableDescriptors(), AbstractNotifiable.buildNotifiable(this.scoreDirector, variableListener, globalOrder));
            this.nextGlobalOrder = globalOrder + 1;
        }
    }

    @Override
    public <Supply_ extends Supply> Supply_ demand(Demand<Supply_> demand) {
        long activeDemandCount = this.demandCounterMap.compute(demand, (key, count) -> count == null ? 1L : count + 1L);
        if (activeDemandCount == 1L) {
            Supply supply = this.createSupply(demand);
            this.supplyMap.put(demand, supply);
            return (Supply_)supply;
        }
        return (Supply_)this.supplyMap.get(demand);
    }

    private Supply createSupply(Demand<?> demand) {
        Object supply = demand.createExternalizedSupply(this);
        if (supply instanceof SourcedVariableListener) {
            SourcedVariableListener variableListener = (SourcedVariableListener)supply;
            if (this.scoreDirector.getWorkingSolution() != null) {
                variableListener.resetWorkingSolution(this.scoreDirector);
            }
            this.notifiableRegistry.registerNotifiable(variableListener.getSourceVariableDescriptor(), AbstractNotifiable.buildNotifiable(this.scoreDirector, variableListener, this.nextGlobalOrder++));
        }
        return supply;
    }

    @Override
    public <Supply_ extends Supply> boolean cancel(Demand<Supply_> demand) {
        Long result = this.demandCounterMap.computeIfPresent(demand, (key, count) -> Objects.equals(count, 1L) ? null : Long.valueOf(count - 1L));
        if (result != null) {
            return true;
        }
        return this.supplyMap.remove(demand) != null;
    }

    @Override
    public <Supply_ extends Supply> long getActiveCount(Demand<Supply_> demand) {
        return this.demandCounterMap.getOrDefault(demand, 0L);
    }

    public void resetWorkingSolution() {
        for (Notifiable notifiable : this.notifiableRegistry.getAll()) {
            notifiable.resetWorkingSolution();
        }
    }

    public void close() {
        for (Notifiable notifiable : this.notifiableRegistry.getAll()) {
            notifiable.closeVariableListener();
        }
    }

    public void beforeEntityAdded(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        Collection<EntityNotifiable<Solution_>> notifiables = this.notifiableRegistry.get(entityDescriptor);
        if (!notifiables.isEmpty()) {
            EntityNotification notification = Notification.entityAdded(entity);
            for (EntityNotifiable notifiable : notifiables) {
                notifiable.notifyBefore(notification);
            }
            this.notificationQueuesAreEmpty = false;
        }
    }

    public void beforeEntityRemoved(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        Collection<EntityNotifiable<Solution_>> notifiables = this.notifiableRegistry.get(entityDescriptor);
        if (!notifiables.isEmpty()) {
            EntityNotification notification = Notification.entityRemoved(entity);
            for (EntityNotifiable notifiable : notifiables) {
                notifiable.notifyBefore(notification);
            }
            this.notificationQueuesAreEmpty = false;
        }
    }

    public void beforeVariableChanged(VariableDescriptor<Solution_> variableDescriptor, Object entity) {
        Collection<VariableListenerNotifiable<Solution_>> notifiables = this.notifiableRegistry.get(variableDescriptor);
        if (!notifiables.isEmpty()) {
            BasicVariableNotification notification = Notification.variableChanged(entity);
            for (VariableListenerNotifiable notifiable : notifiables) {
                notifiable.notifyBefore(notification);
            }
            this.notificationQueuesAreEmpty = false;
        }
    }

    public void afterElementUnassigned(ListVariableDescriptor<Solution_> variableDescriptor, Object element) {
        Collection<ListVariableListenerNotifiable<Solution_>> notifiables = this.notifiableRegistry.get(variableDescriptor);
        if (!notifiables.isEmpty()) {
            ListVariableNotification notification = Notification.elementUnassigned(element);
            for (ListVariableListenerNotifiable notifiable : notifiables) {
                notifiable.notifyAfter(notification);
            }
            this.notificationQueuesAreEmpty = false;
        }
    }

    public void beforeListVariableChanged(ListVariableDescriptor<Solution_> variableDescriptor, Object entity, int fromIndex, int toIndex) {
        Collection<ListVariableListenerNotifiable<Solution_>> notifiables = this.notifiableRegistry.get(variableDescriptor);
        if (!notifiables.isEmpty()) {
            ListVariableNotification notification = Notification.listVariableChanged(entity, fromIndex, toIndex);
            for (ListVariableListenerNotifiable notifiable : notifiables) {
                notifiable.notifyBefore(notification);
            }
            this.notificationQueuesAreEmpty = false;
        }
    }

    public void afterListVariableChanged(ListVariableDescriptor<Solution_> variableDescriptor, Object entity, int fromIndex, int toIndex) {
        Collection<ListVariableListenerNotifiable<Solution_>> notifiables = this.notifiableRegistry.get(variableDescriptor);
        if (!notifiables.isEmpty()) {
            ListVariableNotification notification = Notification.listVariableChanged(entity, fromIndex, toIndex);
            for (ListVariableListenerNotifiable notifiable : notifiables) {
                notifiable.notifyAfter(notification);
            }
            this.notificationQueuesAreEmpty = false;
        }
    }

    public void triggerVariableListenersInNotificationQueues() {
        for (Notifiable notifiable : this.notifiableRegistry.getAll()) {
            notifiable.triggerAllNotifications();
        }
        this.notificationQueuesAreEmpty = true;
    }

    public String createShadowVariablesViolationMessage() {
        Object workingSolution = this.scoreDirector.getWorkingSolution();
        ShadowVariablesAssert snapshot = ShadowVariablesAssert.takeSnapshot(this.scoreDirector.getSolutionDescriptor(), workingSolution);
        this.forceTriggerAllVariableListeners(workingSolution);
        int SHADOW_VARIABLE_VIOLATION_DISPLAY_LIMIT = 3;
        return snapshot.createShadowVariablesViolationMessage(3L);
    }

    public void forceTriggerAllVariableListeners(Solution_ workingSolution) {
        this.scoreDirector.getSolutionDescriptor().visitAllEntities(workingSolution, this::simulateGenuineVariableChange);
        this.triggerVariableListenersInNotificationQueues();
    }

    private void simulateGenuineVariableChange(Object entity) {
        EntityDescriptor<Solution_> entityDescriptor = this.scoreDirector.getSolutionDescriptor().findEntityDescriptorOrFail(entity.getClass());
        for (VariableDescriptor variableDescriptor : entityDescriptor.getGenuineVariableDescriptorList()) {
            this.beforeVariableChanged(variableDescriptor, entity);
        }
    }

    public void assertNotificationQueuesAreEmpty() {
        if (!this.notificationQueuesAreEmpty) {
            throw new IllegalStateException("The notificationQueues might not be empty (" + this.notificationQueuesAreEmpty + ") so any shadow variables might be stale so score calculation is unreliable.\nMaybe a " + ScoreDirector.class.getSimpleName() + ".before*() method was called without calling " + ScoreDirector.class.getSimpleName() + ".triggerVariableListeners(), before calling " + ScoreDirector.class.getSimpleName() + ".calculateScore().");
        }
    }
}

