/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.list.nearby;

import java.util.Iterator;
import java.util.Random;
import java.util.function.Function;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.SelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMatrix;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyRandom;
import org.optaplanner.core.impl.heuristic.selector.list.ElementRef;

final class RandomNearbyDestinationIterator
extends SelectionIterator<ElementRef> {
    private final NearbyDistanceMatrix<Object, Object> nearbyDistanceMatrix;
    private final NearbyRandom nearbyRandom;
    private final Random workingRandom;
    private final Iterator<?> replayingOriginValueIterator;
    private final Function<Iterator<?>, Object> originFunction;
    private final Function<Object, ElementRef> elementRefFunction;
    private final int nearbySize;

    public RandomNearbyDestinationIterator(NearbyDistanceMatrix<Object, Object> nearbyDistanceMatrix, NearbyRandom nearbyRandom, Random workingRandom, Iterator<Object> replayingOriginValueIterator, Function<Object, ElementRef> elementRefFunction, long childSize) {
        this(nearbyDistanceMatrix, nearbyRandom, workingRandom, replayingOriginValueIterator, Iterator::next, elementRefFunction, childSize);
    }

    public RandomNearbyDestinationIterator(NearbyDistanceMatrix<Object, Object> nearbyDistanceMatrix, NearbyRandom nearbyRandom, Random workingRandom, Iterator<?> replayingOriginValueIterator, Function<Iterator<?>, Object> originFunction, Function<Object, ElementRef> elementRefFunction, long childSize) {
        this.nearbyDistanceMatrix = nearbyDistanceMatrix;
        this.nearbyRandom = nearbyRandom;
        this.workingRandom = workingRandom;
        this.replayingOriginValueIterator = replayingOriginValueIterator;
        this.originFunction = originFunction;
        this.elementRefFunction = elementRefFunction;
        if (childSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The destinationSelector (" + this + ") has a destinationSize (" + childSize + ") which is higher than Integer.MAX_VALUE.");
        }
        this.nearbySize = (int)childSize;
    }

    @Override
    public boolean hasNext() {
        return this.replayingOriginValueIterator.hasNext() && this.nearbySize > 0;
    }

    @Override
    public ElementRef next() {
        Object origin = this.originFunction.apply(this.replayingOriginValueIterator);
        int nearbyIndex = this.nearbyRandom.nextInt(this.workingRandom, this.nearbySize);
        Object next = this.nearbyDistanceMatrix.getDestination(origin, nearbyIndex);
        return this.elementRefFunction.apply(next);
    }
}

