/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.factory;

import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.config.heuristic.selector.move.factory.MoveListFactoryConfig;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.heuristic.HeuristicConfigPolicy;
import org.optaplanner.core.impl.heuristic.selector.move.AbstractMoveSelectorFactory;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.factory.MoveListFactory;
import org.optaplanner.core.impl.heuristic.selector.move.factory.MoveListFactoryToMoveSelectorBridge;

public class MoveListFactoryFactory<Solution_>
extends AbstractMoveSelectorFactory<Solution_, MoveListFactoryConfig> {
    public MoveListFactoryFactory(MoveListFactoryConfig moveSelectorConfig) {
        super(moveSelectorConfig);
    }

    @Override
    public MoveSelector<Solution_> buildBaseMoveSelector(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, boolean randomSelection) {
        if (((MoveListFactoryConfig)this.config).getMoveListFactoryClass() == null) {
            throw new IllegalArgumentException("The moveListFactoryConfig (" + this.config + ") lacks a moveListFactoryClass (" + ((MoveListFactoryConfig)this.config).getMoveListFactoryClass() + ").");
        }
        MoveListFactory moveListFactory = ConfigUtils.newInstance(this.config, "moveListFactoryClass", ((MoveListFactoryConfig)this.config).getMoveListFactoryClass());
        ConfigUtils.applyCustomProperties(moveListFactory, "moveListFactoryClass", ((MoveListFactoryConfig)this.config).getMoveListFactoryCustomProperties(), "moveListFactoryCustomProperties");
        if (minimumCacheType.compareTo(SelectionCacheType.STEP) < 0) {
            minimumCacheType = SelectionCacheType.STEP;
        }
        return new MoveListFactoryToMoveSelectorBridge(moveListFactory, minimumCacheType, randomSelection);
    }

    @Override
    protected boolean isBaseInherentlyCached() {
        return true;
    }
}

