/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.valuerange.buildin.biginteger;

import java.math.BigInteger;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import org.optaplanner.core.impl.domain.valuerange.AbstractCountableValueRange;
import org.optaplanner.core.impl.domain.valuerange.util.ValueRangeIterator;
import org.optaplanner.core.impl.solver.random.RandomUtils;

public class BigIntegerValueRange
extends AbstractCountableValueRange<BigInteger> {
    private final BigInteger from;
    private final BigInteger to;
    private final BigInteger incrementUnit;

    public BigIntegerValueRange(BigInteger from, BigInteger to) {
        this(from, to, BigInteger.valueOf(1L));
    }

    public BigIntegerValueRange(BigInteger from, BigInteger to, BigInteger incrementUnit) {
        this.from = from;
        this.to = to;
        this.incrementUnit = incrementUnit;
        if (to.compareTo(from) < 0) {
            throw new IllegalArgumentException("The " + this.getClass().getSimpleName() + " cannot have a from (" + from + ") which is strictly higher than its to (" + to + ").");
        }
        if (incrementUnit.compareTo(BigInteger.ZERO) <= 0) {
            throw new IllegalArgumentException("The " + this.getClass().getSimpleName() + " must have strictly positive incrementUnit (" + incrementUnit + ").");
        }
        if (!to.subtract(from).remainder(incrementUnit).equals(BigInteger.ZERO)) {
            throw new IllegalArgumentException("The " + this.getClass().getSimpleName() + "'s incrementUnit (" + incrementUnit + ") must fit an integer number of times between from (" + from + ") and to (" + to + ").");
        }
    }

    @Override
    public long getSize() {
        return this.to.subtract(this.from).divide(this.incrementUnit).longValue();
    }

    @Override
    public BigInteger get(long index) {
        if (index < 0L || index >= this.getSize()) {
            throw new IndexOutOfBoundsException("The index (" + index + ") must be >= 0 and < size (" + this.getSize() + ").");
        }
        return this.incrementUnit.multiply(BigInteger.valueOf(index)).add(this.from);
    }

    @Override
    public boolean contains(BigInteger value) {
        if (value == null || value.compareTo(this.from) < 0 || value.compareTo(this.to) >= 0) {
            return false;
        }
        return value.subtract(this.from).remainder(this.incrementUnit).compareTo(BigInteger.ZERO) == 0;
    }

    @Override
    public Iterator<BigInteger> createOriginalIterator() {
        return new OriginalBigIntegerValueRangeIterator();
    }

    @Override
    public Iterator<BigInteger> createRandomIterator(Random workingRandom) {
        return new RandomBigIntegerValueRangeIterator(workingRandom);
    }

    public String toString() {
        return "[" + this.from + "-" + this.to + ")";
    }

    private class OriginalBigIntegerValueRangeIterator
    extends ValueRangeIterator<BigInteger> {
        private BigInteger upcoming;

        private OriginalBigIntegerValueRangeIterator() {
            this.upcoming = BigIntegerValueRange.this.from;
        }

        @Override
        public boolean hasNext() {
            return this.upcoming.compareTo(BigIntegerValueRange.this.to) < 0;
        }

        @Override
        public BigInteger next() {
            if (this.upcoming.compareTo(BigIntegerValueRange.this.to) >= 0) {
                throw new NoSuchElementException();
            }
            BigInteger next = this.upcoming;
            this.upcoming = this.upcoming.add(BigIntegerValueRange.this.incrementUnit);
            return next;
        }
    }

    private class RandomBigIntegerValueRangeIterator
    extends ValueRangeIterator<BigInteger> {
        private final Random workingRandom;
        private final long size;

        public RandomBigIntegerValueRangeIterator(Random workingRandom) {
            this.size = BigIntegerValueRange.this.getSize();
            this.workingRandom = workingRandom;
        }

        @Override
        public boolean hasNext() {
            return this.size > 0L;
        }

        @Override
        public BigInteger next() {
            if (this.size <= 0L) {
                throw new NoSuchElementException();
            }
            long index = RandomUtils.nextLong(this.workingRandom, this.size);
            return BigIntegerValueRange.this.incrementUnit.multiply(BigInteger.valueOf(index)).add(BigIntegerValueRange.this.from);
        }
    }
}

