/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.tri;

import java.math.BigDecimal;
import java.util.Set;
import org.optaplanner.constraint.streams.bavet.BavetConstraint;
import org.optaplanner.constraint.streams.bavet.BavetConstraintFactory;
import org.optaplanner.constraint.streams.bavet.common.BavetAbstractConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.BavetScoringConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.NodeBuildHelper;
import org.optaplanner.constraint.streams.bavet.tri.BavetAbstractTriConstraintStream;
import org.optaplanner.constraint.streams.bavet.tri.TriScorer;
import org.optaplanner.constraint.streams.common.inliner.JustificationsSupplier;
import org.optaplanner.constraint.streams.common.inliner.WeightedScoreImpacter;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.function.ToIntTriFunction;
import org.optaplanner.core.api.function.ToLongTriFunction;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintStream;

public final class BavetScoringTriConstraintStream<Solution_, A, B, C>
extends BavetAbstractTriConstraintStream<Solution_, A, B, C>
implements BavetScoringConstraintStream<Solution_> {
    private final BavetAbstractTriConstraintStream<Solution_, A, B, C> parent;
    private final boolean noMatchWeigher;
    private final ToIntTriFunction<A, B, C> intMatchWeigher;
    private final ToLongTriFunction<A, B, C> longMatchWeigher;
    private final TriFunction<A, B, C, BigDecimal> bigDecimalMatchWeigher;
    private BavetConstraint<Solution_> constraint;

    public BavetScoringTriConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractTriConstraintStream<Solution_, A, B, C> parent, ToIntTriFunction<A, B, C> intMatchWeigher) {
        this(constraintFactory, parent, false, intMatchWeigher, null, null);
        if (intMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    public BavetScoringTriConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractTriConstraintStream<Solution_, A, B, C> parent, ToLongTriFunction<A, B, C> longMatchWeigher) {
        this(constraintFactory, parent, false, null, longMatchWeigher, null);
        if (longMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    public BavetScoringTriConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractTriConstraintStream<Solution_, A, B, C> parent, TriFunction<A, B, C, BigDecimal> bigDecimalMatchWeigher) {
        this(constraintFactory, parent, false, null, null, bigDecimalMatchWeigher);
        if (bigDecimalMatchWeigher == null) {
            throw new IllegalArgumentException("The matchWeigher (null) cannot be null.");
        }
    }

    private BavetScoringTriConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractTriConstraintStream<Solution_, A, B, C> parent, boolean noMatchWeigher, ToIntTriFunction<A, B, C> intMatchWeigher, ToLongTriFunction<A, B, C> longMatchWeigher, TriFunction<A, B, C, BigDecimal> bigDecimalMatchWeigher) {
        super(constraintFactory, parent.getRetrievalSemantics());
        this.parent = parent;
        this.noMatchWeigher = noMatchWeigher;
        this.intMatchWeigher = intMatchWeigher;
        this.longMatchWeigher = longMatchWeigher;
        this.bigDecimalMatchWeigher = bigDecimalMatchWeigher;
    }

    @Override
    public void setConstraint(BavetConstraint<Solution_> constraint) {
        this.constraint = constraint;
    }

    public boolean guaranteesDistinct() {
        return this.parent.guaranteesDistinct();
    }

    @Override
    public void collectActiveConstraintStreams(Set<BavetAbstractConstraintStream<Solution_>> constraintStreamSet) {
        this.parent.collectActiveConstraintStreams(constraintStreamSet);
        constraintStreamSet.add(this);
    }

    @Override
    public BavetAbstractConstraintStream<Solution_> getTupleSource() {
        return this.parent.getTupleSource();
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> buildHelper) {
        TriFunction scoreImpacter;
        if (!this.childStreamList.isEmpty()) {
            throw new IllegalStateException("Impossible state: the stream (" + this + ") has an non-empty childStreamList (" + this.childStreamList + ") but it's an endpoint.");
        }
        Score_ constraintWeight = buildHelper.getConstraintWeight((Constraint)this.constraint);
        WeightedScoreImpacter weightedScoreImpacter = buildHelper.getScoreInliner().buildWeightedScoreImpacter(this.constraint, constraintWeight);
        boolean constraintMatchEnabled = buildHelper.getScoreInliner().isConstraintMatchEnabled();
        if (this.intMatchWeigher != null) {
            scoreImpacter = constraintMatchEnabled ? (a, b, c) -> {
                int matchWeight = this.intMatchWeigher.applyAsInt(a, b, c);
                this.constraint.assertCorrectImpact(matchWeight);
                JustificationsSupplier justificationsSupplier = JustificationsSupplier.of(this.constraint, (QuadFunction)((QuadFunction)this.constraint.getJustificationMapping()), (TriFunction)((TriFunction)this.constraint.getIndictedObjectsMapping()), (Object)a, (Object)b, (Object)c);
                return weightedScoreImpacter.impactScore(matchWeight, justificationsSupplier);
            } : (a, b, c) -> {
                int matchWeight = this.intMatchWeigher.applyAsInt(a, b, c);
                this.constraint.assertCorrectImpact(matchWeight);
                return weightedScoreImpacter.impactScore(matchWeight, null);
            };
        } else if (this.longMatchWeigher != null) {
            scoreImpacter = constraintMatchEnabled ? (a, b, c) -> {
                long matchWeight = this.longMatchWeigher.applyAsLong(a, b, c);
                this.constraint.assertCorrectImpact(matchWeight);
                JustificationsSupplier justificationsSupplier = JustificationsSupplier.of(this.constraint, (QuadFunction)((QuadFunction)this.constraint.getJustificationMapping()), (TriFunction)((TriFunction)this.constraint.getIndictedObjectsMapping()), (Object)a, (Object)b, (Object)c);
                return weightedScoreImpacter.impactScore(matchWeight, justificationsSupplier);
            } : (a, b, c) -> {
                long matchWeight = this.longMatchWeigher.applyAsLong(a, b, c);
                this.constraint.assertCorrectImpact(matchWeight);
                return weightedScoreImpacter.impactScore(matchWeight, null);
            };
        } else if (this.bigDecimalMatchWeigher != null) {
            scoreImpacter = constraintMatchEnabled ? (a, b, c) -> {
                BigDecimal matchWeight = (BigDecimal)this.bigDecimalMatchWeigher.apply(a, b, c);
                this.constraint.assertCorrectImpact(matchWeight);
                JustificationsSupplier justificationsSupplier = JustificationsSupplier.of(this.constraint, (QuadFunction)((QuadFunction)this.constraint.getJustificationMapping()), (TriFunction)((TriFunction)this.constraint.getIndictedObjectsMapping()), (Object)a, (Object)b, (Object)c);
                return weightedScoreImpacter.impactScore(matchWeight, justificationsSupplier);
            } : (a, b, c) -> {
                BigDecimal matchWeight = (BigDecimal)this.bigDecimalMatchWeigher.apply(a, b, c);
                this.constraint.assertCorrectImpact(matchWeight);
                return weightedScoreImpacter.impactScore(matchWeight, null);
            };
        } else if (this.noMatchWeigher) {
            scoreImpacter = constraintMatchEnabled ? (a, b, c) -> {
                JustificationsSupplier justificationsSupplier = JustificationsSupplier.of(this.constraint, (QuadFunction)((QuadFunction)this.constraint.getJustificationMapping()), (TriFunction)((TriFunction)this.constraint.getIndictedObjectsMapping()), (Object)a, (Object)b, (Object)c);
                return weightedScoreImpacter.impactScore(1, justificationsSupplier);
            } : (a, b, c) -> weightedScoreImpacter.impactScore(1, null);
        } else {
            throw new IllegalStateException("Impossible state: neither of the supported match weighers provided.");
        }
        TriScorer scorer = new TriScorer(this.constraint.getConstraintPackage(), this.constraint.getConstraintName(), (Score<?>)constraintWeight, scoreImpacter, buildHelper.reserveTupleStoreIndex((ConstraintStream)this.parent.getTupleSource()));
        buildHelper.putInsertUpdateRetract((ConstraintStream)this, scorer);
    }

    public String toString() {
        return "Scoring(" + this.constraint.getConstraintName() + ")";
    }
}

