/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.regression.pde.impl;

import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Hashtable;
import org.ops4j.pax.exam.regression.pde.HelloService;
import org.ops4j.pax.exam.regression.pde.Notifier;
import org.ops4j.pax.exam.regression.pde.impl.EnglishHelloService;
import org.ops4j.pax.exam.regression.pde.impl.LatinHelloService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    public void start(BundleContext bc) throws Exception {
        EnglishHelloService service = new EnglishHelloService();
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("language", "en");
        bc.registerService(HelloService.class.getName(), (Object)service, props);
        LatinHelloService latinService = new LatinHelloService();
        Hashtable<String, String> latinProps = new Hashtable<String, String>();
        latinProps.put("language", "la");
        bc.registerService(HelloService.class.getName(), (Object)latinService, latinProps);
        String rmiProperty = System.getProperty("pax.exam.regression.rmi");
        if (rmiProperty != null) {
            this.notifyRemoteListener(rmiProperty);
        }
    }

    private void notifyRemoteListener(String rmiProperty) throws Exception {
        int rmiPort = Integer.parseInt(rmiProperty);
        Registry registry = LocateRegistry.getRegistry(rmiPort);
        Remote remote = registry.lookup("PaxExamNotifier");
        Notifier notifier = (Notifier)remote;
        notifier.send("bundle org.ops4j.pax.exam.regression.pde started");
    }

    public void stop(BundleContext bc) throws Exception {
        String blockOnStop = System.getProperty("pax.exam.regression.blockOnStop", "false");
        if (Boolean.valueOf(blockOnStop).booleanValue()) {
            Thread.sleep(Long.MAX_VALUE);
        }
    }
}

