/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.model.xml.impl.type.reference;

import org.operaton.bpm.model.xml.Model;
import org.operaton.bpm.model.xml.ModelException;
import org.operaton.bpm.model.xml.impl.ModelBuildOperation;
import org.operaton.bpm.model.xml.impl.type.ModelElementTypeImpl;
import org.operaton.bpm.model.xml.impl.type.attribute.AttributeImpl;
import org.operaton.bpm.model.xml.instance.ModelElementInstance;
import org.operaton.bpm.model.xml.type.reference.AttributeReferenceCollection;
import org.operaton.bpm.model.xml.type.reference.AttributeReferenceCollectionBuilder;

public class AttributeReferenceCollectionBuilderImpl<T extends ModelElementInstance>
implements AttributeReferenceCollectionBuilder<T>,
ModelBuildOperation {
    private final AttributeImpl<String> referenceSourceAttribute;
    protected AttributeReferenceCollection<T> attributeReferenceCollection;
    private final Class<T> referenceTargetElement;

    public AttributeReferenceCollectionBuilderImpl(AttributeImpl<String> attribute, Class<T> referenceTargetElement, Class<? extends AttributeReferenceCollection> attributeReferenceCollection) {
        this.referenceSourceAttribute = attribute;
        this.referenceTargetElement = referenceTargetElement;
        try {
            this.attributeReferenceCollection = attributeReferenceCollection.getConstructor(AttributeImpl.class).newInstance(this.referenceSourceAttribute);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public AttributeReferenceCollection<T> build() {
        this.referenceSourceAttribute.registerOutgoingReference(this.attributeReferenceCollection);
        return this.attributeReferenceCollection;
    }

    @Override
    public void performModelBuild(Model model) {
        ModelElementTypeImpl referenceTargetType = (ModelElementTypeImpl)model.getType(this.referenceTargetElement);
        this.attributeReferenceCollection.setReferenceTargetElementType(referenceTargetType);
        AttributeImpl idAttribute = (AttributeImpl)referenceTargetType.getAttribute("id");
        if (idAttribute == null) {
            throw new ModelException("Element type %s:%s has no id attribute".formatted(referenceTargetType.getTypeNamespace(), referenceTargetType.getTypeName()));
        }
        idAttribute.registerIncoming(this.attributeReferenceCollection);
        this.attributeReferenceCollection.setReferenceTargetAttribute(idAttribute);
    }
}

