/*
 * Decompiled with CFR 0.152.
 */
package com.google.bbq;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.valid4j.Assertive;

public final class QueryUtil {
    public static final String BBQ_CATEGORY = "com.google.bbq.QUERY";
    public static final String EXTRA_QUERY_MESSAGE = "com.google.bbq.message";
    public static final String EXTRA_RESPONSE_MESSAGE = "com.google.bbq.response";
    private static final int HALF_BYTE_WIDTH = 4;
    private static final int HALF_BYTE_MASK = 15;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private QueryUtil() {
    }

    public static Intent createEmptyQueryIntent(@NonNull String dataType) {
        Assertive.require((!TextUtils.isEmpty((CharSequence)dataType) ? 1 : 0) != 0, (String)"dataType must not be null or empty", (Object[])new Object[0]);
        Intent queryIntent = new Intent(dataType);
        queryIntent.addCategory(BBQ_CATEGORY);
        return queryIntent;
    }

    public static String createResponseAction(@NonNull String dataType, long requestId) {
        Assertive.require((Object)dataType, (Matcher)CoreMatchers.notNullValue());
        return dataType + ":" + QueryUtil.longAsHex(requestId);
    }

    public static Set<String> getRespondersForDataType(@NonNull Context context, @NonNull String dataType) {
        Assertive.require((Object)context, (Matcher)CoreMatchers.notNullValue());
        Assertive.require((Object)dataType, (Matcher)CoreMatchers.notNullValue());
        PackageManager packageManager = context.getPackageManager();
        Intent intent = new Intent(dataType);
        intent.addCategory(BBQ_CATEGORY);
        List responderInfos = packageManager.queryBroadcastReceivers(intent, 64);
        HashSet<String> responders = new HashSet<String>();
        for (ResolveInfo info : responderInfos) {
            responders.add(info.activityInfo.packageName);
        }
        return responders;
    }

    @VisibleForTesting
    static String longAsHex(long val) {
        char[] result = new char[16];
        int index = result.length - 1;
        while (index >= 0) {
            result[index--] = HEX_DIGITS[(int)(val & 0xFL)];
            result[index--] = HEX_DIGITS[(int)((val >>>= 4) & 0xFL)];
            val >>>= 4;
        }
        return new String(result);
    }
}

