/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.visualizer;

import org.opentripplanner.astar.spi.TraverseVisitor;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.visualizer.ShowGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisualTraverseVisitor
implements TraverseVisitor<State, Edge> {
    private static final Logger LOG = LoggerFactory.getLogger(VisualTraverseVisitor.class);
    private final ShowGraph gui;
    private final int SLEEP_AFTER = 50;
    private final int SLEEP_LEN = 2;
    private int sleepAfter = 50;

    public VisualTraverseVisitor(ShowGraph gui) {
        this.gui = gui;
    }

    @Override
    public void visitEdge(Edge edge) {
        this.gui.enqueueHighlightedEdge(edge);
    }

    @Override
    public void visitVertex(State state) {
        if (--this.sleepAfter <= 0) {
            this.sleepAfter = 50;
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException e) {
                LOG.warn("interrupted", (Throwable)e);
            }
        }
        this.gui.addNewSPTEdge(state);
    }

    @Override
    public void visitEnqueue() {
    }
}

