/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.vehicle_rental.datasources;

import org.entur.gbfs.v2_3.vehicle_types.GBFSVehicleType;
import org.opentripplanner.service.vehiclerental.model.RentalVehicleType;
import org.opentripplanner.street.model.RentalFormFactor;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public class GbfsVehicleTypeMapper {
    private final String systemId;

    public GbfsVehicleTypeMapper(String systemId) {
        this.systemId = systemId;
    }

    public RentalVehicleType mapRentalVehicleType(GBFSVehicleType vehicleType) {
        return new RentalVehicleType(new FeedScopedId(this.systemId, vehicleType.getVehicleTypeId()), vehicleType.getName(), GbfsVehicleTypeMapper.fromGbfs(vehicleType.getFormFactor()), RentalVehicleType.PropulsionType.fromGbfs(vehicleType.getPropulsionType()), vehicleType.getMaxRangeMeters());
    }

    private static RentalFormFactor fromGbfs(GBFSVehicleType.FormFactor formFactor) {
        return switch (formFactor) {
            default -> throw new IncompatibleClassChangeError();
            case GBFSVehicleType.FormFactor.BICYCLE -> RentalFormFactor.BICYCLE;
            case GBFSVehicleType.FormFactor.CARGO_BICYCLE -> RentalFormFactor.CARGO_BICYCLE;
            case GBFSVehicleType.FormFactor.CAR -> RentalFormFactor.CAR;
            case GBFSVehicleType.FormFactor.MOPED -> RentalFormFactor.MOPED;
            case GBFSVehicleType.FormFactor.SCOOTER -> RentalFormFactor.SCOOTER;
            case GBFSVehicleType.FormFactor.SCOOTER_STANDING -> RentalFormFactor.SCOOTER_STANDING;
            case GBFSVehicleType.FormFactor.SCOOTER_SEATED -> RentalFormFactor.SCOOTER_SEATED;
            case GBFSVehicleType.FormFactor.OTHER -> RentalFormFactor.OTHER;
        };
    }
}

