/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.vehicle_rental.datasources;

import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.entur.gbfs.v2_3.geofencing_zones.GBFSFeature;
import org.entur.gbfs.v2_3.geofencing_zones.GBFSGeofencingZones;
import org.entur.gbfs.v2_3.geofencing_zones.GBFSRule;
import org.geojson.GeoJsonObject;
import org.locationtech.jts.geom.Geometry;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.geometry.UnsupportedGeometryException;
import org.opentripplanner.service.vehiclerental.model.GeofencingZone;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GbfsGeofencingZoneMapper {
    private static final Logger LOG = LoggerFactory.getLogger(GeofencingZone.class);
    private final String systemId;

    public GbfsGeofencingZoneMapper(String systemId) {
        this.systemId = systemId;
    }

    public List<GeofencingZone> mapGeofencingZone(GBFSGeofencingZones input) {
        return input.getData().getGeofencingZones().getFeatures().stream().map(this::toInternalModel).filter(Objects::nonNull).toList();
    }

    @Nullable
    private GeofencingZone toInternalModel(GBFSFeature f) {
        Geometry g;
        try {
            g = GeometryUtils.convertGeoJsonToJtsGeometry((GeoJsonObject)f.getGeometry());
        }
        catch (UnsupportedGeometryException e) {
            LOG.error("Could not convert geofencing zone", (Throwable)e);
            return null;
        }
        String name = Objects.requireNonNullElseGet(f.getProperties().getName(), () -> GbfsGeofencingZoneMapper.fallbackId(g));
        boolean dropOffBanned = ((GBFSRule)f.getProperties().getRules().get(0)).getRideAllowed() == false;
        boolean passThroughBanned = ((GBFSRule)f.getProperties().getRules().get(0)).getRideThroughAllowed() == false;
        return new GeofencingZone(new FeedScopedId(this.systemId, name), g, dropOffBanned, passThroughBanned);
    }

    private static String fallbackId(Geometry geom) {
        return Hashing.murmur3_32_fixed().hashBytes(geom.toString().getBytes(StandardCharsets.UTF_8)).toString();
    }
}

