/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.vehicle_rental;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opentripplanner.framework.time.TimeUtils;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.linking.DisposableEdgeCollection;
import org.opentripplanner.routing.linking.LinkingDirection;
import org.opentripplanner.routing.linking.VertexLinker;
import org.opentripplanner.service.vehiclerental.VehicleRentalRepository;
import org.opentripplanner.service.vehiclerental.model.GeofencingZone;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalPlace;
import org.opentripplanner.service.vehiclerental.street.StreetVehicleRentalLink;
import org.opentripplanner.service.vehiclerental.street.VehicleRentalEdge;
import org.opentripplanner.service.vehiclerental.street.VehicleRentalPlaceVertex;
import org.opentripplanner.street.model.RentalFormFactor;
import org.opentripplanner.street.model.RentalRestrictionExtension;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.model.vertex.StreetVertex;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.TraverseModeSet;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.service.TransitModel;
import org.opentripplanner.updater.GraphWriterRunnable;
import org.opentripplanner.updater.spi.PollingGraphUpdater;
import org.opentripplanner.updater.spi.UpdaterConstructionException;
import org.opentripplanner.updater.spi.WriteToGraphCallback;
import org.opentripplanner.updater.vehicle_rental.GeofencingVertexUpdater;
import org.opentripplanner.updater.vehicle_rental.VehicleRentalUpdaterParameters;
import org.opentripplanner.updater.vehicle_rental.datasources.VehicleRentalDatasource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VehicleRentalUpdater
extends PollingGraphUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(VehicleRentalUpdater.class);
    private final VehicleRentalDatasource source;
    private WriteToGraphCallback saveResultOnGraph;
    private Map<StreetEdge, RentalRestrictionExtension> latestModifiedEdges = Map.of();
    private Set<GeofencingZone> latestAppliedGeofencingZones = Set.of();
    Map<FeedScopedId, VehicleRentalPlaceVertex> verticesByStation = new HashMap<FeedScopedId, VehicleRentalPlaceVertex>();
    Map<FeedScopedId, DisposableEdgeCollection> tempEdgesByStation = new HashMap<FeedScopedId, DisposableEdgeCollection>();
    private final VertexLinker linker;
    private final VehicleRentalRepository service;

    public VehicleRentalUpdater(VehicleRentalUpdaterParameters parameters, VehicleRentalDatasource source, VertexLinker vertexLinker, VehicleRentalRepository repository) throws IllegalArgumentException {
        super(parameters);
        LOG.info("Setting up vehicle rental updater.");
        this.source = source;
        this.linker = vertexLinker;
        this.service = repository;
        try {
            source.setup();
        }
        catch (UpdaterConstructionException e) {
            LOG.warn("Unable to setup updater: {}", (Object)parameters.configRef(), (Object)e);
        }
        if (this.pollingPeriodSeconds() <= 0) {
            LOG.info("Creating vehicle-rental updater running once only (non-polling): {}", (Object)source);
        } else {
            LOG.info("Creating vehicle-rental updater running every {} seconds: {}", (Object)this.pollingPeriodSeconds(), (Object)source);
        }
    }

    @Override
    public void setGraphUpdaterManager(WriteToGraphCallback saveResultOnGraph) {
        this.saveResultOnGraph = saveResultOnGraph;
    }

    public String toString() {
        return ToStringBuilder.of(VehicleRentalUpdater.class).addObj("source", this.source).toString();
    }

    @Override
    public String getConfigRef() {
        return this.toString();
    }

    @Override
    protected void runPolling() {
        LOG.debug("Updating vehicle rental stations from {}", (Object)this.source);
        if (!this.source.update()) {
            LOG.debug("No updates");
            return;
        }
        List<VehicleRentalPlace> stations = this.source.getUpdates();
        List<GeofencingZone> geofencingZones = this.source.getGeofencingZones();
        VehicleRentalGraphWriterRunnable graphWriterRunnable = new VehicleRentalGraphWriterRunnable(stations, geofencingZones);
        this.saveResultOnGraph.execute(graphWriterRunnable);
    }

    private class VehicleRentalGraphWriterRunnable
    implements GraphWriterRunnable {
        private final List<VehicleRentalPlace> stations;
        private final Set<GeofencingZone> geofencingZones;

        public VehicleRentalGraphWriterRunnable(List<VehicleRentalPlace> stations, List<GeofencingZone> geofencingZones) {
            this.stations = stations;
            this.geofencingZones = Set.copyOf(geofencingZones);
        }

        @Override
        public void run(Graph graph, TransitModel transitModel) {
            HashSet<FeedScopedId> stationSet = new HashSet<FeedScopedId>();
            for (VehicleRentalPlace vehicleRentalPlace : this.stations) {
                VehicleRentalUpdater.this.service.addVehicleRentalStation(vehicleRentalPlace);
                stationSet.add(vehicleRentalPlace.getId());
                VehicleRentalPlaceVertex vehicleRentalPlaceVertex = VehicleRentalUpdater.this.verticesByStation.get(vehicleRentalPlace.getId());
                if (vehicleRentalPlaceVertex == null) {
                    VehicleRentalPlaceVertex vehicleRentalPlaceVertex2 = new VehicleRentalPlaceVertex(graph, vehicleRentalPlace);
                    DisposableEdgeCollection tempEdges = VehicleRentalUpdater.this.linker.linkVertexForRealTime(vehicleRentalPlaceVertex2, new TraverseModeSet(TraverseMode.WALK), LinkingDirection.BOTH_WAYS, (vertex, streetVertex) -> List.of(new StreetVehicleRentalLink((VehicleRentalPlaceVertex)vertex, (StreetVertex)streetVertex), new StreetVehicleRentalLink((StreetVertex)streetVertex, (VehicleRentalPlaceVertex)vertex)));
                    if (vehicleRentalPlaceVertex2.getOutgoing().isEmpty()) {
                        LOG.info("VehicleRentalPlace {} is unlinked", (Object)vehicleRentalPlaceVertex2);
                    }
                    Set formFactors = Stream.concat(vehicleRentalPlace.getAvailablePickupFormFactors(false).stream(), vehicleRentalPlace.getAvailableDropoffFormFactors(false).stream()).collect(Collectors.toSet());
                    for (RentalFormFactor formFactor : formFactors) {
                        tempEdges.addEdge(new VehicleRentalEdge(vehicleRentalPlaceVertex2, formFactor));
                    }
                    VehicleRentalUpdater.this.verticesByStation.put(vehicleRentalPlace.getId(), vehicleRentalPlaceVertex2);
                    VehicleRentalUpdater.this.tempEdgesByStation.put(vehicleRentalPlace.getId(), tempEdges);
                    continue;
                }
                vehicleRentalPlaceVertex.setStation(vehicleRentalPlace);
            }
            ArrayList<FeedScopedId> toRemove = new ArrayList<FeedScopedId>();
            for (Map.Entry<FeedScopedId, VehicleRentalPlaceVertex> entry : VehicleRentalUpdater.this.verticesByStation.entrySet()) {
                FeedScopedId station = entry.getKey();
                if (stationSet.contains(station)) continue;
                toRemove.add(station);
                VehicleRentalUpdater.this.service.removeVehicleRentalStation(station);
            }
            for (FeedScopedId feedScopedId : toRemove) {
                VehicleRentalUpdater.this.verticesByStation.remove(feedScopedId);
                VehicleRentalUpdater.this.tempEdgesByStation.get(feedScopedId).disposeEdges();
                VehicleRentalUpdater.this.tempEdgesByStation.remove(feedScopedId);
            }
            if (!this.geofencingZones.isEmpty() && !this.geofencingZones.equals(VehicleRentalUpdater.this.latestAppliedGeofencingZones)) {
                LOG.info("Computing geofencing zones");
                long l = System.currentTimeMillis();
                VehicleRentalUpdater.this.latestModifiedEdges.forEach(StreetEdge::removeRentalExtension);
                GeofencingVertexUpdater updater = new GeofencingVertexUpdater(graph.getStreetIndex()::getEdgesForEnvelope);
                VehicleRentalUpdater.this.latestModifiedEdges = updater.applyGeofencingZones(this.geofencingZones);
                VehicleRentalUpdater.this.latestAppliedGeofencingZones = this.geofencingZones;
                long end = System.currentTimeMillis();
                Duration millis = Duration.ofMillis(end - l);
                LOG.info("Geofencing zones computation took {}. Added extension to {} edges.", (Object)TimeUtils.durationToStrCompact(millis), (Object)VehicleRentalUpdater.this.latestModifiedEdges.size());
            }
        }
    }
}

