/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.vehicle_position;

import com.google.transit.realtime.GtfsRealtime;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.opentripplanner.framework.io.HttpUtils;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.updater.spi.HttpHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtfsRealtimeHttpVehiclePositionSource {
    private static final Logger LOG = LoggerFactory.getLogger(GtfsRealtimeHttpVehiclePositionSource.class);
    private final URI url;
    private final HttpHeaders headers;

    public GtfsRealtimeHttpVehiclePositionSource(URI url, HttpHeaders headers) {
        this.url = url;
        this.headers = HttpHeaders.of().acceptProtobuf().add(headers).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<GtfsRealtime.VehiclePosition> getPositions() {
        try (InputStream is = HttpUtils.openInputStream(this.url.toString(), this.headers.asMap());){
            if (is == null) {
                LOG.warn("Failed to get data from url {}", (Object)this.url);
                List<GtfsRealtime.VehiclePosition> list2 = List.of();
                return list2;
            }
            List<GtfsRealtime.VehiclePosition> list = this.getPositions(is);
            return list;
        }
        catch (IOException e) {
            LOG.warn("Error reading vehicle positions from {}", (Object)this.url, (Object)e);
            return List.of();
        }
    }

    public String toString() {
        return ToStringBuilder.of(GtfsRealtimeHttpVehiclePositionSource.class).addObj("url", this.url).toString();
    }

    public List<GtfsRealtime.VehiclePosition> getPositions(InputStream is) throws IOException {
        ArrayList<GtfsRealtime.VehiclePosition> positions = null;
        if (is != null) {
            GtfsRealtime.FeedMessage feedMessage = GtfsRealtime.FeedMessage.parseFrom(is);
            List<GtfsRealtime.FeedEntity> feedEntityList = feedMessage.getEntityList();
            positions = new ArrayList<GtfsRealtime.VehiclePosition>(feedEntityList.size());
            for (GtfsRealtime.FeedEntity feedEntity : feedEntityList) {
                if (!feedEntity.hasVehicle()) continue;
                positions.add(feedEntity.getVehicle());
            }
        }
        return positions;
    }
}

