/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.vehicle_parking;

import org.opentripplanner.ext.vehicleparking.bikely.BikelyUpdater;
import org.opentripplanner.ext.vehicleparking.bikely.BikelyUpdaterParameters;
import org.opentripplanner.ext.vehicleparking.hslpark.HslParkUpdater;
import org.opentripplanner.ext.vehicleparking.hslpark.HslParkUpdaterParameters;
import org.opentripplanner.ext.vehicleparking.parkapi.BicycleParkAPIUpdater;
import org.opentripplanner.ext.vehicleparking.parkapi.CarParkAPIUpdater;
import org.opentripplanner.ext.vehicleparking.parkapi.ParkAPIUpdaterParameters;
import org.opentripplanner.model.calendar.openinghours.OpeningHoursCalendarService;
import org.opentripplanner.routing.vehicle_parking.VehicleParking;
import org.opentripplanner.updater.spi.DataSource;
import org.opentripplanner.updater.vehicle_parking.VehicleParkingSourceType;
import org.opentripplanner.updater.vehicle_parking.VehicleParkingUpdaterParameters;

public class VehicleParkingDataSourceFactory {
    private VehicleParkingDataSourceFactory() {
    }

    public static DataSource<VehicleParking> create(VehicleParkingUpdaterParameters parameters, OpeningHoursCalendarService openingHoursCalendarService) {
        return switch (parameters.sourceType()) {
            default -> throw new IncompatibleClassChangeError();
            case VehicleParkingSourceType.HSL_PARK -> new HslParkUpdater((HslParkUpdaterParameters)parameters, openingHoursCalendarService);
            case VehicleParkingSourceType.PARK_API -> new CarParkAPIUpdater((ParkAPIUpdaterParameters)parameters, openingHoursCalendarService);
            case VehicleParkingSourceType.BICYCLE_PARK_API -> new BicycleParkAPIUpdater((ParkAPIUpdaterParameters)parameters, openingHoursCalendarService);
            case VehicleParkingSourceType.BIKELY -> new BikelyUpdater((BikelyUpdaterParameters)parameters);
        };
    }
}

