/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.transit.realtime.GtfsRealtime;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.ws.WebSocket;
import org.asynchttpclient.ws.WebSocketListener;
import org.asynchttpclient.ws.WebSocketUpgradeHandler;
import org.opentripplanner.transit.service.DefaultTransitService;
import org.opentripplanner.transit.service.TransitModel;
import org.opentripplanner.updater.GtfsRealtimeFuzzyTripMatcher;
import org.opentripplanner.updater.spi.GraphUpdater;
import org.opentripplanner.updater.spi.UpdateResult;
import org.opentripplanner.updater.spi.WriteToGraphCallback;
import org.opentripplanner.updater.trip.BackwardsDelayPropagationType;
import org.opentripplanner.updater.trip.TimetableSnapshotSource;
import org.opentripplanner.updater.trip.TripUpdateGraphWriterRunnable;
import org.opentripplanner.updater.trip.WebsocketGtfsRealtimeUpdaterParameters;
import org.opentripplanner.updater.trip.metrics.TripUpdateMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketGtfsRealtimeUpdater
implements GraphUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(WebsocketGtfsRealtimeUpdater.class);
    private static final int CHECK_CONNECTION_PERIOD_SEC = 1;
    private final String url;
    private final String feedId;
    private final int reconnectPeriodSec;
    private final String configRef;
    private final BackwardsDelayPropagationType backwardsDelayPropagationType;
    private final TimetableSnapshotSource snapshotSource;
    private WriteToGraphCallback saveResultOnGraph;
    private GtfsRealtimeFuzzyTripMatcher fuzzyTripMatcher;
    private final Consumer<UpdateResult> recordMetrics;

    public WebsocketGtfsRealtimeUpdater(WebsocketGtfsRealtimeUpdaterParameters parameters, TimetableSnapshotSource snapshotSource, TransitModel transitModel) {
        this.configRef = parameters.configRef();
        this.url = parameters.url();
        this.feedId = parameters.feedId();
        this.reconnectPeriodSec = parameters.getReconnectPeriodSec();
        this.backwardsDelayPropagationType = parameters.getBackwardsDelayPropagationType();
        this.snapshotSource = snapshotSource;
        this.fuzzyTripMatcher = new GtfsRealtimeFuzzyTripMatcher(new DefaultTransitService(transitModel));
        this.recordMetrics = TripUpdateMetrics.streaming(parameters);
    }

    @Override
    public void setGraphUpdaterManager(WriteToGraphCallback saveResultOnGraph) {
        this.saveResultOnGraph = saveResultOnGraph;
    }

    @Override
    public void run() throws InterruptedException, IOException {
        while (true) {
            AsyncHttpClient client = Dsl.asyncHttpClient();
            Listener listener = new Listener();
            WebSocketUpgradeHandler handler = new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)listener).build();
            WebSocket socket = null;
            boolean connectionSuccessful = true;
            try {
                socket = (WebSocket)client.prepareGet(this.url).execute((AsyncHandler)handler).get();
                LOG.info("Successfully connected to {}.", (Object)this.url);
            }
            catch (ExecutionException e) {
                LOG.error("Could not connect to {}: {}", (Object)this.url, (Object)e.getCause().getMessage());
                connectionSuccessful = false;
            }
            catch (Exception e) {
                LOG.error("Unknown exception when trying to connect to {}.", (Object)this.url, (Object)e);
                connectionSuccessful = false;
            }
            if (!connectionSuccessful) {
                Thread.sleep(this.reconnectPeriodSec * 1000);
            }
            while (true) {
                if (socket == null || !socket.isOpen()) {
                    if (!connectionSuccessful) break;
                    LOG.warn("Connection to {} was lost. Trying to reconnect...", (Object)this.url);
                    break;
                }
                Thread.sleep(1000L);
            }
            client.close();
        }
    }

    @Override
    public String getConfigRef() {
        return this.configRef;
    }

    private class Listener
    implements WebSocketListener {
        private Listener() {
        }

        public void onOpen(WebSocket websocket) {
        }

        public void onClose(WebSocket websocket, int code, String reason) {
        }

        public void onError(Throwable t) {
        }

        public void onBinaryFrame(byte[] message, boolean finalFragment, int rsv) {
            ArrayList<GtfsRealtime.TripUpdate> updates = null;
            boolean fullDataset = true;
            try {
                GtfsRealtime.FeedMessage feedMessage = (GtfsRealtime.FeedMessage)GtfsRealtime.FeedMessage.PARSER.parseFrom(message);
                List<GtfsRealtime.FeedEntity> feedEntityList = feedMessage.getEntityList();
                if (feedMessage.hasHeader() && feedMessage.getHeader().hasIncrementality() && feedMessage.getHeader().getIncrementality().equals((Object)GtfsRealtime.FeedHeader.Incrementality.DIFFERENTIAL)) {
                    fullDataset = false;
                }
                updates = new ArrayList<GtfsRealtime.TripUpdate>(feedEntityList.size());
                for (GtfsRealtime.FeedEntity feedEntity : feedEntityList) {
                    if (!feedEntity.hasTripUpdate()) continue;
                    updates.add(feedEntity.getTripUpdate());
                }
            }
            catch (InvalidProtocolBufferException e) {
                LOG.error("Could not decode gtfs-rt message:", (Throwable)e);
            }
            if (updates != null) {
                TripUpdateGraphWriterRunnable runnable = new TripUpdateGraphWriterRunnable(WebsocketGtfsRealtimeUpdater.this.snapshotSource, WebsocketGtfsRealtimeUpdater.this.fuzzyTripMatcher, WebsocketGtfsRealtimeUpdater.this.backwardsDelayPropagationType, fullDataset, updates, WebsocketGtfsRealtimeUpdater.this.feedId, WebsocketGtfsRealtimeUpdater.this.recordMetrics);
                WebsocketGtfsRealtimeUpdater.this.saveResultOnGraph.execute(runnable);
            }
        }
    }
}

