/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.trip;

import com.google.transit.realtime.GtfsRealtime;
import de.mfdz.MfdzRealtimeExtensions;
import java.util.Objects;

final class AddedRoute {
    public static final int FALLBACK_ROUTE_TYPE = 3;
    private final String routeUrl;
    private final String agencyId;
    private final Integer routeType;
    private final String routeLongName;

    public AddedRoute(String routeUrl, String agencyId, Integer routeType, String routeLongName) {
        this.routeUrl = routeUrl;
        this.agencyId = agencyId;
        this.routeType = routeType;
        this.routeLongName = routeLongName;
    }

    public int routeType() {
        return Objects.requireNonNullElse(this.routeType, 3);
    }

    public String routeUrl() {
        return this.routeUrl;
    }

    public String agencyId() {
        return this.agencyId;
    }

    public String routeLongName() {
        return this.routeLongName;
    }

    static AddedRoute ofTripDescriptor(GtfsRealtime.TripDescriptor tripDescriptor) {
        if (tripDescriptor.hasExtension(MfdzRealtimeExtensions.tripDescriptor)) {
            MfdzRealtimeExtensions.TripDescriptorExtension ext = (MfdzRealtimeExtensions.TripDescriptorExtension)tripDescriptor.getExtension(MfdzRealtimeExtensions.tripDescriptor);
            String url = ext.getRouteUrl();
            String agencyId = ext.getAgencyId();
            int routeType = ext.getRouteType();
            String routeName = ext.getRouteLongName();
            return new AddedRoute(url, agencyId, routeType, routeName);
        }
        return new AddedRoute(null, null, null, null);
    }
}

