/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.spi;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.opentripplanner.framework.lang.DoubleUtils;
import org.opentripplanner.model.UpdateError;
import org.opentripplanner.updater.spi.UpdateResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultLogger {
    private static final Logger LOG = LoggerFactory.getLogger(ResultLogger.class);

    public static void logUpdateResult(String feedId, String type, UpdateResult updateResult) {
        int totalUpdates = updateResult.successful() + updateResult.failed();
        if (totalUpdates > 0) {
            LOG.info("[feedId: {}, type={}] {} of {} update messages were applied successfully (success rate: {}%)", new Object[]{feedId, type, updateResult.successful(), totalUpdates, DoubleUtils.roundTo2Decimals((double)updateResult.successful() / (double)totalUpdates * 100.0)});
            Multimap<UpdateError.UpdateErrorType, UpdateError> errorIndex = updateResult.failures();
            errorIndex.keySet().forEach(key -> {
                Collection value = errorIndex.get((Object)key);
                Set tripIds = value.stream().map(UpdateError::debugId).collect(Collectors.toSet());
                LOG.error("[feedId: {}, type={}] {} failures of type {}: {}", new Object[]{feedId, type, value.size(), key, tripIds});
            });
        } else {
            LOG.info("[feedId: {}, type={}] Feed did not contain any updates", (Object)feedId, (Object)type);
        }
    }
}

