/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.timetable;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.model.BookingInfo;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.model.UpdateError;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.framework.Deduplicator;
import org.opentripplanner.transit.model.framework.Result;
import org.opentripplanner.transit.model.timetable.OccupancyStatus;
import org.opentripplanner.transit.model.timetable.RealTimeState;
import org.opentripplanner.transit.model.timetable.StopRealTimeState;
import org.opentripplanner.transit.model.timetable.Trip;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TripTimes
implements Serializable,
Comparable<TripTimes> {
    private static final Logger LOG = LoggerFactory.getLogger(TripTimes.class);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final Trip trip;
    private I18NString[] headsigns;
    private final String[][] headsignVias;
    private final int[] scheduledArrivalTimes;
    private final int[] scheduledDepartureTimes;
    private final List<BookingInfo> dropOffBookingInfos;
    private final List<BookingInfo> pickupBookingInfos;
    private final int[] originalGtfsStopSequence;
    private final BitSet timepoints;
    private int timeShift;
    private int serviceCode = -1;
    private int[] arrivalTimes;
    private int[] departureTimes;
    private StopRealTimeState[] stopRealTimeStates;
    private OccupancyStatus[] occupancyStatus;
    private RealTimeState realTimeState = RealTimeState.SCHEDULED;
    public Accessibility wheelchairAccessibility;

    public TripTimes(Trip trip, Collection<StopTime> stopTimes, Deduplicator deduplicator) {
        this.trip = trip;
        int nStops = stopTimes.size();
        int[] departures = new int[nStops];
        int[] arrivals = new int[nStops];
        int[] sequences = new int[nStops];
        BitSet timepoints = new BitSet(nStops);
        this.timeShift = stopTimes.iterator().next().getArrivalTime();
        ArrayList<BookingInfo> dropOffBookingInfos = new ArrayList<BookingInfo>();
        ArrayList<BookingInfo> pickupBookingInfos = new ArrayList<BookingInfo>();
        int s = 0;
        for (StopTime st : stopTimes) {
            departures[s] = st.getDepartureTime() - this.timeShift;
            arrivals[s] = st.getArrivalTime() - this.timeShift;
            sequences[s] = st.getStopSequence();
            timepoints.set(s, st.getTimepoint() == 1);
            dropOffBookingInfos.add(st.getDropOffBookingInfo());
            pickupBookingInfos.add(st.getPickupBookingInfo());
            ++s;
        }
        this.scheduledDepartureTimes = deduplicator.deduplicateIntArray(departures);
        this.scheduledArrivalTimes = deduplicator.deduplicateIntArray(arrivals);
        this.originalGtfsStopSequence = deduplicator.deduplicateIntArray(sequences);
        this.headsigns = deduplicator.deduplicateObjectArray(I18NString.class, this.makeHeadsignsArray(stopTimes));
        this.headsignVias = deduplicator.deduplicateString2DArray(this.makeHeadsignViasArray(stopTimes));
        this.dropOffBookingInfos = deduplicator.deduplicateImmutableList(BookingInfo.class, dropOffBookingInfos);
        this.pickupBookingInfos = deduplicator.deduplicateImmutableList(BookingInfo.class, pickupBookingInfos);
        this.arrivalTimes = null;
        this.departureTimes = null;
        this.stopRealTimeStates = null;
        this.timepoints = deduplicator.deduplicateBitSet(timepoints);
        this.wheelchairAccessibility = trip.getWheelchairBoarding();
        LOG.trace("trip {} has timepoint at indexes {}", (Object)trip, (Object)timepoints);
    }

    public TripTimes(TripTimes object) {
        this.timeShift = object.timeShift;
        this.trip = object.trip;
        this.serviceCode = object.serviceCode;
        this.headsigns = object.headsigns;
        this.headsignVias = object.headsignVias;
        this.scheduledArrivalTimes = object.scheduledArrivalTimes;
        this.scheduledDepartureTimes = object.scheduledDepartureTimes;
        this.arrivalTimes = null;
        this.departureTimes = null;
        this.stopRealTimeStates = object.stopRealTimeStates;
        this.pickupBookingInfos = object.pickupBookingInfos;
        this.dropOffBookingInfos = object.dropOffBookingInfos;
        this.originalGtfsStopSequence = object.originalGtfsStopSequence;
        this.realTimeState = object.realTimeState;
        this.timepoints = object.timepoints;
        this.wheelchairAccessibility = object.wheelchairAccessibility;
        this.occupancyStatus = object.occupancyStatus;
    }

    public I18NString getHeadsign(int stop) {
        if (this.headsigns == null) {
            return this.getTrip().getHeadsign();
        }
        return this.headsigns[stop];
    }

    public List<String> getHeadsignVias(int stop) {
        if (this.headsignVias == null || this.headsignVias[stop] == null) {
            return List.of();
        }
        return List.of(this.headsignVias[stop]);
    }

    public I18NString getTripHeadsign() {
        return this.trip.getHeadsign();
    }

    public int getScheduledArrivalTime(int stop) {
        return this.scheduledArrivalTimes[stop] + this.timeShift;
    }

    public int getScheduledDepartureTime(int stop) {
        return this.scheduledDepartureTimes[stop] + this.timeShift;
    }

    public int sortIndex() {
        return this.getDepartureTime(0);
    }

    public int getArrivalTime(int stop) {
        if (this.arrivalTimes == null) {
            return this.getScheduledArrivalTime(stop);
        }
        return this.arrivalTimes[stop];
    }

    public int getDepartureTime(int stop) {
        if (this.departureTimes == null) {
            return this.getScheduledDepartureTime(stop);
        }
        return this.departureTimes[stop];
    }

    public int getArrivalDelay(int stop) {
        return this.getArrivalTime(stop) - (this.scheduledArrivalTimes[stop] + this.timeShift);
    }

    public int getDepartureDelay(int stop) {
        return this.getDepartureTime(stop) - (this.scheduledDepartureTimes[stop] + this.timeShift);
    }

    public void setRecorded(int stop) {
        this.prepareForRealTimeUpdates();
        this.stopRealTimeStates[stop] = StopRealTimeState.RECORDED;
    }

    public void setCancelled(int stop) {
        this.prepareForRealTimeUpdates();
        this.stopRealTimeStates[stop] = StopRealTimeState.CANCELLED;
    }

    public void setNoData(int stop) {
        this.prepareForRealTimeUpdates();
        this.stopRealTimeStates[stop] = StopRealTimeState.NO_DATA;
    }

    public void setPredictionInaccurate(int stop) {
        this.prepareForRealTimeUpdates();
        this.stopRealTimeStates[stop] = StopRealTimeState.INACCURATE_PREDICTIONS;
    }

    public boolean isCancelledStop(int stop) {
        if (this.stopRealTimeStates == null) {
            return false;
        }
        return this.stopRealTimeStates[stop] == StopRealTimeState.CANCELLED;
    }

    public boolean isRecordedStop(int stop) {
        if (this.stopRealTimeStates == null) {
            return false;
        }
        return this.stopRealTimeStates[stop] == StopRealTimeState.RECORDED;
    }

    public boolean isNoDataStop(int stop) {
        if (this.stopRealTimeStates == null) {
            return false;
        }
        return this.stopRealTimeStates[stop] == StopRealTimeState.NO_DATA;
    }

    public boolean isPredictionInaccurate(int stop) {
        if (this.stopRealTimeStates == null) {
            return false;
        }
        return this.stopRealTimeStates[stop] == StopRealTimeState.INACCURATE_PREDICTIONS;
    }

    public void setOccupancyStatus(int stop, OccupancyStatus occupancyStatus) {
        this.prepareForRealTimeUpdates();
        this.occupancyStatus[stop] = occupancyStatus;
    }

    public OccupancyStatus getOccupancyStatus(int stop) {
        if (this.occupancyStatus == null) {
            return OccupancyStatus.NO_DATA;
        }
        return this.occupancyStatus[stop];
    }

    public BookingInfo getDropOffBookingInfo(int stop) {
        return this.dropOffBookingInfos.get(stop);
    }

    public BookingInfo getPickupBookingInfo(int stop) {
        return this.pickupBookingInfos.get(stop);
    }

    public boolean isScheduled() {
        return this.realTimeState == RealTimeState.SCHEDULED;
    }

    public boolean isCanceledOrDeleted() {
        return this.isCanceled() || this.isDeleted();
    }

    public boolean isCanceled() {
        return this.realTimeState == RealTimeState.CANCELED;
    }

    public boolean isDeleted() {
        return this.realTimeState == RealTimeState.DELETED;
    }

    public RealTimeState getRealTimeState() {
        return this.realTimeState;
    }

    public void setRealTimeState(RealTimeState realTimeState) {
        this.realTimeState = realTimeState;
    }

    public Result<?, UpdateError> validateNonIncreasingTimes() {
        int nStops = this.scheduledArrivalTimes.length;
        int prevDep = -9999999;
        for (int s = 0; s < nStops; ++s) {
            int arr = this.getArrivalTime(s);
            int dep = this.getDepartureTime(s);
            if (dep < arr) {
                return Result.failure(new UpdateError(this.getTrip().getId(), UpdateError.UpdateErrorType.NEGATIVE_DWELL_TIME, s));
            }
            if (prevDep > arr) {
                return Result.failure(new UpdateError(this.getTrip().getId(), UpdateError.UpdateErrorType.NEGATIVE_HOP_TIME, s));
            }
            prevDep = dep;
        }
        return Result.success();
    }

    public void cancelTrip() {
        this.realTimeState = RealTimeState.CANCELED;
    }

    public void deleteTrip() {
        this.realTimeState = RealTimeState.DELETED;
    }

    public void updateDepartureTime(int stop, int time) {
        this.prepareForRealTimeUpdates();
        this.departureTimes[stop] = time;
    }

    public void updateDepartureDelay(int stop, int delay) {
        this.prepareForRealTimeUpdates();
        this.departureTimes[stop] = this.scheduledDepartureTimes[stop] + this.timeShift + delay;
    }

    public void updateArrivalTime(int stop, int time) {
        this.prepareForRealTimeUpdates();
        this.arrivalTimes[stop] = time;
    }

    public void updateArrivalDelay(int stop, int delay) {
        this.prepareForRealTimeUpdates();
        this.arrivalTimes[stop] = this.scheduledArrivalTimes[stop] + this.timeShift + delay;
    }

    public Accessibility getWheelchairAccessibility() {
        return this.wheelchairAccessibility;
    }

    public void updateWheelchairAccessibility(Accessibility wheelchairAccessibility) {
        this.wheelchairAccessibility = wheelchairAccessibility;
    }

    public int getNumStops() {
        return this.scheduledArrivalTimes.length;
    }

    @Override
    public int compareTo(TripTimes other) {
        return this.getDepartureTime(0) - other.getDepartureTime(0);
    }

    public TripTimes timeShift(int stop, int time, boolean depart) {
        if (this.arrivalTimes != null || this.departureTimes != null) {
            return null;
        }
        TripTimes shifted = new TripTimes(this);
        int shift = time - (depart ? this.getDepartureTime(stop) : this.getArrivalTime(stop));
        shifted.timeShift += shift;
        return shifted;
    }

    public void timeShift(Duration duration) {
        this.timeShift = (int)((long)this.timeShift + duration.toSeconds());
    }

    public int getOriginalGtfsStopSequence(int stop) {
        return this.originalGtfsStopSequence[stop];
    }

    public boolean isTimepoint(int stopIndex) {
        return this.timepoints.get(stopIndex);
    }

    public int getServiceCode() {
        return this.serviceCode;
    }

    public void setServiceCode(int serviceCode) {
        this.serviceCode = serviceCode;
    }

    public Trip getTrip() {
        return this.trip;
    }

    public boolean adjustTimesBeforeAlways(int firstUpdatedIndex) {
        boolean hasAdjustedTimes = false;
        int delay = this.getDepartureDelay(firstUpdatedIndex);
        if (this.getArrivalDelay(firstUpdatedIndex) == 0) {
            this.updateArrivalDelay(firstUpdatedIndex, delay);
            hasAdjustedTimes = true;
        }
        if ((delay = this.getArrivalDelay(firstUpdatedIndex)) == 0) {
            return false;
        }
        for (int i = firstUpdatedIndex - 1; i >= 0; --i) {
            hasAdjustedTimes = true;
            this.updateDepartureDelay(i, delay);
            this.updateArrivalDelay(i, delay);
        }
        return hasAdjustedTimes;
    }

    public boolean adjustTimesBeforeWhenRequired(int firstUpdatedIndex, boolean setNoData) {
        if (this.getArrivalTime(firstUpdatedIndex) > this.getDepartureTime(firstUpdatedIndex)) {
            return false;
        }
        int nextStopArrivalTime = this.getArrivalTime(firstUpdatedIndex);
        int delay = this.getArrivalDelay(firstUpdatedIndex);
        boolean hasAdjustedTimes = false;
        boolean adjustTimes = true;
        for (int i = firstUpdatedIndex - 1; i >= 0; --i) {
            if (setNoData && !this.isCancelledStop(i)) {
                this.setNoData(i);
            }
            if (!adjustTimes) continue;
            if (this.getDepartureTime(i) < nextStopArrivalTime) {
                adjustTimes = false;
                continue;
            }
            hasAdjustedTimes = true;
            this.updateDepartureDelay(i, delay);
            if (this.getArrivalTime(i) < this.getDepartureTime(i)) {
                adjustTimes = false;
                continue;
            }
            this.updateArrivalDelay(i, delay);
            nextStopArrivalTime = this.getArrivalTime(i);
        }
        return hasAdjustedTimes;
    }

    private I18NString[] makeHeadsignsArray(Collection<StopTime> stopTimes) {
        I18NString tripHeadsign = this.trip.getHeadsign();
        boolean useStopHeadsigns = false;
        if (tripHeadsign == null) {
            useStopHeadsigns = true;
        } else {
            for (StopTime st : stopTimes) {
                if (tripHeadsign.equals(st.getStopHeadsign())) continue;
                useStopHeadsigns = true;
                break;
            }
        }
        if (!useStopHeadsigns) {
            return null;
        }
        boolean allNull = true;
        int i = 0;
        I18NString[] hs = new I18NString[stopTimes.size()];
        for (StopTime st : stopTimes) {
            I18NString headsign = st.getStopHeadsign();
            hs[i++] = headsign;
            if (headsign == null) continue;
            allNull = false;
        }
        if (allNull) {
            return null;
        }
        return hs;
    }

    public void setHeadsign(int index, I18NString headsign) {
        if (this.headsigns == null) {
            if (headsign.equals(this.trip.getHeadsign())) {
                return;
            }
            this.headsigns = new I18NString[this.scheduledArrivalTimes.length];
            this.headsigns[index] = headsign;
            return;
        }
        this.prepareForRealTimeUpdates();
        this.headsigns[index] = headsign;
    }

    private String[][] makeHeadsignViasArray(Collection<StopTime> stopTimes) {
        if (stopTimes.stream().allMatch(st -> st.getHeadsignVias() == null || st.getHeadsignVias().isEmpty())) {
            return null;
        }
        String[][] vias = new String[stopTimes.size()][];
        int i = 0;
        for (StopTime st2 : stopTimes) {
            if (st2.getHeadsignVias() == null) {
                vias[i] = EMPTY_STRING_ARRAY;
                ++i;
                continue;
            }
            vias[i] = st2.getHeadsignVias().toArray(EMPTY_STRING_ARRAY);
            ++i;
        }
        return vias;
    }

    private void prepareForRealTimeUpdates() {
        if (this.arrivalTimes == null) {
            this.arrivalTimes = Arrays.copyOf(this.scheduledArrivalTimes, this.scheduledArrivalTimes.length);
            this.departureTimes = Arrays.copyOf(this.scheduledDepartureTimes, this.scheduledDepartureTimes.length);
            this.stopRealTimeStates = new StopRealTimeState[this.arrivalTimes.length];
            this.occupancyStatus = new OccupancyStatus[this.arrivalTimes.length];
            if (this.headsigns != null) {
                this.headsigns = Arrays.copyOf(this.headsigns, this.headsigns.length);
            }
            for (int i = 0; i < this.arrivalTimes.length; ++i) {
                int n = i;
                this.arrivalTimes[n] = this.arrivalTimes[n] + this.timeShift;
                int n2 = i;
                this.departureTimes[n2] = this.departureTimes[n2] + this.timeShift;
                this.stopRealTimeStates[i] = StopRealTimeState.DEFAULT;
                this.occupancyStatus[i] = OccupancyStatus.NO_DATA;
            }
            this.realTimeState = RealTimeState.UPDATED;
        }
    }
}

