/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.organization;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opentripplanner.framework.lang.StringUtils;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.framework.LogInfo;
import org.opentripplanner.transit.model.organization.OperatorBuilder;

public class Operator
extends AbstractTransitEntity<Operator, OperatorBuilder>
implements LogInfo {
    private final String name;
    private final String url;
    private final String phone;

    Operator(OperatorBuilder builder) {
        super(builder.getId());
        this.name = StringUtils.assertHasValue(builder.getName(), "Missing mandatory name on Operator %s", builder.getId());
        this.url = builder.getUrl();
        this.phone = builder.getPhone();
    }

    public static OperatorBuilder of(@Nonnull FeedScopedId id) {
        return new OperatorBuilder(id);
    }

    @Nonnull
    public String getName() {
        return this.logName();
    }

    @Override
    @Nonnull
    public String logName() {
        return this.name;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    @Nullable
    public String getPhone() {
        return this.phone;
    }

    @Nonnull
    public OperatorBuilder copy() {
        return new OperatorBuilder(this);
    }

    @Override
    public boolean sameAs(@Nonnull Operator other) {
        return this.getId().equals(other.getId()) && Objects.equals(this.name, other.name) && Objects.equals(this.url, other.url) && Objects.equals(this.phone, other.phone);
    }
}

