/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.network;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.transit.model.basic.SubMode;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.framework.LogInfo;
import org.opentripplanner.transit.model.network.BikeAccess;
import org.opentripplanner.transit.model.network.GroupOfRoutes;
import org.opentripplanner.transit.model.network.RouteBuilder;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.organization.Branding;
import org.opentripplanner.transit.model.organization.Operator;

public final class Route
extends AbstractTransitEntity<Route, RouteBuilder>
implements LogInfo {
    private final Agency agency;
    private final Operator operator;
    private final Branding branding;
    private final List<GroupOfRoutes> groupsOfRoutes;
    private final String shortName;
    private final I18NString longName;
    private final TransitMode mode;
    private final Integer gtfsType;
    private final Integer gtfsSortOrder;
    private final SubMode netexSubmode;
    private final String flexibleLineType;
    private final String description;
    private final String url;
    private final String color;
    private final String textColor;
    private final BikeAccess bikesAllowed;

    Route(RouteBuilder builder) {
        super(builder.getId());
        this.agency = Objects.requireNonNull(builder.getAgency());
        this.mode = Objects.requireNonNull(builder.getMode());
        this.bikesAllowed = Objects.requireNonNullElse(builder.getBikesAllowed(), BikeAccess.UNKNOWN);
        this.shortName = builder.getShortName();
        this.longName = builder.getLongName();
        Objects.requireNonNull(this.getName());
        this.operator = builder.getOperator();
        this.branding = builder.getBranding();
        this.groupsOfRoutes = Route.listOfNullSafe(builder.getGroupsOfRoutes());
        this.gtfsType = builder.getGtfsType();
        this.gtfsSortOrder = builder.getGtfsSortOrder();
        this.netexSubmode = SubMode.getOrBuildAndCacheForever(builder.getNetexSubmode());
        this.flexibleLineType = builder.getFlexibleLineType();
        this.description = builder.getDescription();
        this.url = builder.getUrl();
        this.color = builder.getColor();
        this.textColor = builder.getTextColor();
    }

    public static RouteBuilder of(@Nonnull FeedScopedId id) {
        return new RouteBuilder(id);
    }

    @Override
    public boolean sameAs(@Nonnull Route other) {
        return this.getId().equals(other.getId()) && Objects.equals(this.agency, other.agency) && Objects.equals(this.operator, other.operator) && Objects.equals(this.groupsOfRoutes, other.groupsOfRoutes) && Objects.equals(this.shortName, other.shortName) && Objects.equals(this.longName, other.longName) && Objects.equals(this.branding, other.branding) && Objects.equals((Object)this.mode, (Object)other.mode) && Objects.equals(this.gtfsType, other.gtfsType) && Objects.equals(this.gtfsSortOrder, other.gtfsSortOrder) && Objects.equals(this.flexibleLineType, other.flexibleLineType) && Objects.equals(this.netexSubmode, other.netexSubmode) && Objects.equals(this.description, other.description) && Objects.equals(this.url, other.url) && Objects.equals(this.color, other.color) && Objects.equals(this.textColor, other.textColor) && Objects.equals((Object)this.bikesAllowed, (Object)other.bikesAllowed);
    }

    public RouteBuilder copy() {
        return new RouteBuilder(this);
    }

    @Nonnull
    public Agency getAgency() {
        return this.agency;
    }

    @Nullable
    public Operator getOperator() {
        return this.operator;
    }

    @Nullable
    public Branding getBranding() {
        return this.branding;
    }

    @Nonnull
    public List<GroupOfRoutes> getGroupsOfRoutes() {
        return this.groupsOfRoutes;
    }

    @Nullable
    public String getShortName() {
        return this.shortName;
    }

    @Nullable
    public I18NString getLongName() {
        return this.longName;
    }

    @Nonnull
    public TransitMode getMode() {
        return this.mode;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public Integer getGtfsType() {
        return this.gtfsType;
    }

    @Nullable
    public Integer getGtfsSortOrder() {
        return this.gtfsSortOrder;
    }

    @Nonnull
    public SubMode getNetexSubmode() {
        return this.netexSubmode;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    @Nullable
    public String getColor() {
        return this.color;
    }

    @Nullable
    public String getTextColor() {
        return this.textColor;
    }

    @Nonnull
    public BikeAccess getBikesAllowed() {
        return this.bikesAllowed;
    }

    @Nullable
    public String getFlexibleLineType() {
        return this.flexibleLineType;
    }

    @Nonnull
    public String getName(Locale locale) {
        return this.shortName == null ? this.longName.toString(locale) : this.shortName;
    }

    @Nonnull
    public String getName() {
        return this.shortName == null ? this.longName.toString() : this.shortName;
    }

    @Override
    public String logName() {
        return this.mode.name() + " " + this.getName();
    }
}

