/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.basic;

import java.util.Objects;
import javax.annotation.Nonnull;
import org.opentripplanner.transit.model.basic.NoticeBuilder;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public class Notice
extends AbstractTransitEntity<Notice, NoticeBuilder> {
    private final String text;
    private final String publicCode;

    Notice(NoticeBuilder builder) {
        super(builder.getId());
        this.publicCode = builder.publicCode();
        this.text = builder.text();
    }

    public static NoticeBuilder of(FeedScopedId id) {
        return new NoticeBuilder(id);
    }

    public String text() {
        return this.text;
    }

    public String publicCode() {
        return this.publicCode;
    }

    @Override
    public boolean sameAs(@Nonnull Notice other) {
        return this.getId().equals(other.getId()) && Objects.equals(this.publicCode, other.publicCode) && Objects.equals(this.text, other.text);
    }

    @Nonnull
    public NoticeBuilder copy() {
        return new NoticeBuilder(this);
    }
}

