/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.basic;

import java.text.NumberFormat;
import java.util.Currency;
import java.util.Locale;

public record Money(Currency currency, int amount) implements Comparable<Money>
{
    public static Money euros(int cents) {
        return new Money(Currency.getInstance("EUR"), cents);
    }

    public static Money usDollars(int cents) {
        return new Money(Currency.getInstance("USD"), cents);
    }

    @Override
    public int compareTo(Money m) {
        if (m.currency != this.currency) {
            throw new RuntimeException("Can't compare " + m.currency + " to " + this.currency);
        }
        return this.amount - m.amount;
    }

    public String localize(Locale loc) {
        NumberFormat nf = NumberFormat.getCurrencyInstance(loc);
        nf.setCurrency(this.currency);
        nf.setMaximumFractionDigits(this.currency.getDefaultFractionDigits());
        return nf.format((double)this.amount / Math.pow(10.0, this.currency.getDefaultFractionDigits()));
    }

    @Override
    public String toString() {
        return this.localize(Locale.ENGLISH);
    }
}

