/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.transit.model.basic;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opentripplanner.transit.model.basic.SubMode;
import org.opentripplanner.transit.model.basic.TransitMode;

public record MainAndSubMode(@Nonnull TransitMode mainMode, @Nullable SubMode subMode) {
    private static final List<MainAndSubMode> ALL = Stream.of(TransitMode.values()).map(MainAndSubMode::new).toList();

    public MainAndSubMode(TransitMode mode) {
        this(mode, null);
    }

    public static List<MainAndSubMode> all() {
        return ALL;
    }

    public static List<MainAndSubMode> notMainModes(Collection<MainAndSubMode> modes) {
        return MainAndSubMode.all().stream().filter(Predicate.not(modes::contains)).toList();
    }

    public boolean isMainModeOnly() {
        return this.subMode == null;
    }

    @Override
    public String toString() {
        if (this.subMode == null) {
            return this.mainMode.name();
        }
        return this.mainMode.name() + "::" + this.subMode;
    }

    public static String toString(Collection<MainAndSubMode> modes) {
        return modes != null ? modes.stream().map(MainAndSubMode::toString).sorted().toList().toString() : null;
    }
}

