/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.search.intersection_model;

import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.model.vertex.IntersectionVertex;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.intersection_model.IntersectionTraversalCalculator;

public abstract class AbstractIntersectionTraversalCalculator
implements IntersectionTraversalCalculator {
    protected double nonDrivingTurnDurationFactor = 0.05;

    @Override
    public abstract double computeTraversalDuration(IntersectionVertex var1, StreetEdge var2, StreetEdge var3, TraverseMode var4, float var5, float var6);

    protected double computeNonDrivingTraversalDuration(StreetEdge from, StreetEdge to, float toSpeed) {
        int inAngle;
        int outAngle = to.getOutAngle();
        int turnCost = Math.abs(outAngle - (inAngle = from.getInAngle()));
        if (turnCost > 180) {
            turnCost = 360 - turnCost;
        }
        return this.nonDrivingTurnDurationFactor * (double)turnCost / (double)toSpeed;
    }

    protected int calculateTurnAngle(StreetEdge from, StreetEdge to) {
        int angleIntoIntersection;
        int angleOutOfIntersection = to.getInAngle();
        if (angleOutOfIntersection < (angleIntoIntersection = from.getOutAngle())) {
            angleOutOfIntersection += 360;
        }
        return angleOutOfIntersection - angleIntoIntersection;
    }
}

