/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.vertex;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.astar.spi.AStarVertex;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.street.model.RentalRestrictionExtension;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.search.state.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Vertex
implements AStarVertex<State, Edge, Vertex>,
Serializable,
Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(Vertex.class);
    private final String label;
    private final double x;
    private final double y;
    private I18NString name;
    private transient Edge[] incoming = new Edge[0];
    private transient Edge[] outgoing = new Edge[0];
    private RentalRestrictionExtension rentalRestrictions = RentalRestrictionExtension.NO_RESTRICTION;

    protected Vertex(Graph g, String label, double x, double y) {
        this.label = label;
        this.x = x;
        this.y = y;
        if (g != null) {
            g.addVertex(this);
        }
        this.name = new NonLocalizedString("(no name provided)");
    }

    protected Vertex(Graph g, String label, double x, double y, I18NString name) {
        this(g, label, x, y);
        this.name = name;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{").append(this.getLabel());
        if (this.getCoordinate() != null) {
            sb.append(" lat,lng=").append(this.getCoordinate().y);
            sb.append(",").append(this.getCoordinate().x);
        }
        if (!this.rentalRestrictions.toList().isEmpty()) {
            sb.append(", traversalExtension=").append(this.rentalRestrictions);
        }
        sb.append("}");
        return sb.toString();
    }

    public void initEdgeLists() {
        this.outgoing = new Edge[0];
        this.incoming = new Edge[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutgoing(Edge edge) {
        Vertex vertex = this;
        synchronized (vertex) {
            this.outgoing = Vertex.addEdge(this.outgoing, edge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeOutgoing(Edge edge) {
        Vertex vertex = this;
        synchronized (vertex) {
            int n = this.outgoing.length;
            this.outgoing = Vertex.removeEdge(this.outgoing, edge);
            return this.outgoing.length < n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIncoming(Edge edge) {
        Vertex vertex = this;
        synchronized (vertex) {
            this.incoming = Vertex.addEdge(this.incoming, edge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeIncoming(Edge edge) {
        Vertex vertex = this;
        synchronized (vertex) {
            int n = this.incoming.length;
            this.incoming = Vertex.removeEdge(this.incoming, edge);
            return this.incoming.length < n;
        }
    }

    @Override
    public Collection<Edge> getOutgoing() {
        return Arrays.asList(this.outgoing);
    }

    @Override
    public Collection<Edge> getIncoming() {
        return Arrays.asList(this.incoming);
    }

    public int getDegreeOut() {
        return this.outgoing.length;
    }

    public int getDegreeIn() {
        return this.incoming.length;
    }

    public final double getX() {
        return this.getLon();
    }

    public final double getY() {
        return this.getLat();
    }

    public final double getLon() {
        return this.x;
    }

    public final double getLat() {
        return this.y;
    }

    public I18NString getName() {
        return this.name;
    }

    public String getDefaultName() {
        return this.name.toString();
    }

    public String getLabel() {
        return this.label;
    }

    public Coordinate getCoordinate() {
        return new Coordinate(this.getX(), this.getY());
    }

    public List<StreetEdge> getIncomingStreetEdges() {
        ArrayList<StreetEdge> result = new ArrayList<StreetEdge>();
        for (Edge out : this.getIncoming()) {
            if (!(out instanceof StreetEdge)) continue;
            result.add((StreetEdge)out);
        }
        return result;
    }

    public List<StreetEdge> getOutgoingStreetEdges() {
        ArrayList<StreetEdge> result = new ArrayList<StreetEdge>();
        for (Edge out : this.getOutgoing()) {
            if (!(out instanceof StreetEdge)) continue;
            result.add((StreetEdge)out);
        }
        return result;
    }

    public boolean isConnected(Vertex v) {
        for (Edge e : this.outgoing) {
            if (e.getToVertex() != v) continue;
            return true;
        }
        for (Edge e : this.incoming) {
            if (e.getFromVertex() != v) continue;
            return true;
        }
        return false;
    }

    public boolean rentalTraversalBanned(State currentState) {
        return this.rentalRestrictions.traversalBanned(currentState);
    }

    public void addRentalRestriction(RentalRestrictionExtension ext) {
        this.rentalRestrictions = this.rentalRestrictions.add(ext);
    }

    public RentalRestrictionExtension rentalRestrictions() {
        return this.rentalRestrictions;
    }

    public boolean rentalDropOffBanned(State currentState) {
        return this.rentalRestrictions.dropOffBanned(currentState);
    }

    public void removeRentalRestriction(RentalRestrictionExtension ext) {
        this.rentalRestrictions.remove(ext);
    }

    private static Edge[] addEdge(Edge[] existing, Edge e) {
        Edge[] copy = new Edge[existing.length + 1];
        for (int i = 0; i < existing.length; ++i) {
            if (existing[i] == e) {
                LOG.error("repeatedly added edge {}", (Object)e);
                return existing;
            }
            copy[i] = existing[i];
        }
        copy[i] = e;
        return copy;
    }

    private static Edge[] removeEdge(Edge[] existing, Edge e) {
        int nfound = 0;
        boolean j = false;
        for (int i = 0; i < existing.length; ++i) {
            if (existing[i] != e) continue;
            ++nfound;
        }
        if (nfound == 0) {
            LOG.error("Requested removal of an edge which isn't connected to this vertex.");
            return existing;
        }
        if (nfound > 1) {
            LOG.error("There are multiple copies of the edge to be removed.)");
        }
        Edge[] copy = new Edge[existing.length - nfound];
        int j2 = 0;
        for (int i = 0; i < existing.length; ++i) {
            if (existing[i] == e) continue;
            copy[j2++] = existing[i];
        }
        return copy;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.incoming = new Edge[0];
        this.outgoing = new Edge[0];
    }
}

