/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.vertex;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.PathwayEdge;
import org.opentripplanner.street.model.vertex.StationElementVertex;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.StationElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransitStopVertex
extends StationElementVertex {
    private static final Logger LOG = LoggerFactory.getLogger(TransitStopVertex.class);
    private final Set<TransitMode> modes;
    private final Accessibility wheelchairAccessibility;
    private final RegularStop stop;
    private int streetToStopTime = 0;

    TransitStopVertex(Graph graph, RegularStop stop, Set<TransitMode> modes) {
        super(graph, stop.getId().toString(), stop.getLon(), stop.getLat(), stop.getName());
        this.stop = stop;
        this.modes = modes != null ? modes : new HashSet();
        this.wheelchairAccessibility = stop.getWheelchairAccessibility();
    }

    public Accessibility getWheelchairAccessibility() {
        return this.wheelchairAccessibility;
    }

    public boolean hasPathways() {
        for (Edge e : this.getOutgoing()) {
            if (!(e instanceof PathwayEdge)) continue;
            return true;
        }
        for (Edge e : this.getIncoming()) {
            if (!(e instanceof PathwayEdge)) continue;
            return true;
        }
        return false;
    }

    public int getStreetToStopTime() {
        return this.streetToStopTime;
    }

    public void setStreetToStopTime(int streetToStopTime) {
        this.streetToStopTime = streetToStopTime;
        LOG.debug("Stop {} access time from street level set to {}", (Object)this, (Object)streetToStopTime);
    }

    public Set<TransitMode> getModes() {
        return this.modes;
    }

    public void addMode(TransitMode mode) {
        this.modes.add(mode);
    }

    public RegularStop getStop() {
        return this.stop;
    }

    @Override
    @Nonnull
    public StationElement getStationElement() {
        return this.stop;
    }
}

