/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.edge;

import org.locationtech.jts.geom.LineString;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.routing.api.request.request.VehicleParkingRequest;
import org.opentripplanner.routing.vehicle_parking.VehicleParking;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingEntrance;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.vertex.StreetVertex;
import org.opentripplanner.street.model.vertex.VehicleParkingEntranceVertex;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.street.search.state.StateEditor;

public class StreetVehicleParkingLink
extends Edge {
    private final VehicleParkingEntranceVertex vehicleParkingEntranceVertex;

    public StreetVehicleParkingLink(StreetVertex fromv, VehicleParkingEntranceVertex tov) {
        super(fromv, tov);
        this.vehicleParkingEntranceVertex = tov;
    }

    public StreetVehicleParkingLink(VehicleParkingEntranceVertex fromv, StreetVertex tov) {
        super(fromv, tov);
        this.vehicleParkingEntranceVertex = fromv;
    }

    @Override
    public String toString() {
        return ToStringBuilder.of(this.getClass()).addObj("fromv", this.fromv).addObj("tov", this.tov).toString();
    }

    @Override
    public State traverse(State s0) {
        if (s0.getBackEdge() instanceof StreetVehicleParkingLink) {
            return null;
        }
        VehicleParkingEntrance entrance = this.vehicleParkingEntranceVertex.getParkingEntrance();
        if (s0.getNonTransitMode() == TraverseMode.CAR ? !entrance.isCarAccessible() : !entrance.isWalkAccessible()) {
            return null;
        }
        VehicleParking vehicleParking = this.vehicleParkingEntranceVertex.getVehicleParking();
        VehicleParkingRequest parkingRequest = s0.getRequest().parking();
        if (this.traversalBanned(parkingRequest, vehicleParking)) {
            return null;
        }
        StateEditor s1 = s0.edit(this);
        s1.incrementWeight(1.0);
        s1.setBackMode(null);
        return s1.makeState();
    }

    private boolean traversalBanned(VehicleParkingRequest parkingRequest, VehicleParking vehicleParking) {
        return !parkingRequest.filter().matches(vehicleParking);
    }

    @Override
    public I18NString getName() {
        return this.vehicleParkingEntranceVertex.getName();
    }

    @Override
    public LineString getGeometry() {
        return null;
    }

    @Override
    public double getDistanceMeters() {
        return 0.0;
    }
}

