/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.edge;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.routing.api.request.preference.WheelchairPreferences;
import org.opentripplanner.street.model.edge.CarPickupableEdge;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.vertex.StreetVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.street.search.state.StateEditor;
import org.opentripplanner.transit.model.basic.Accessibility;

public abstract class StreetTransitEntityLink<T extends Vertex>
extends Edge
implements CarPickupableEdge {
    static final int STEL_TRAVERSE_COST = 1;
    private final T transitEntityVertex;
    private final Accessibility wheelchairAccessibility;

    public StreetTransitEntityLink(StreetVertex fromv, T tov, Accessibility wheelchairAccessibility) {
        super(fromv, (Vertex)tov);
        this.transitEntityVertex = tov;
        this.wheelchairAccessibility = wheelchairAccessibility;
    }

    public StreetTransitEntityLink(T fromv, StreetVertex tov, Accessibility wheelchairAccessibility) {
        super((Vertex)fromv, tov);
        this.transitEntityVertex = fromv;
        this.wheelchairAccessibility = wheelchairAccessibility;
    }

    @Override
    public String toString() {
        return ToStringBuilder.of(this.getClass()).addObj("from", this.fromv).addObj("to", this.tov).toString();
    }

    @Override
    public boolean isRoundabout() {
        return false;
    }

    @Override
    public State traverse(State s0) {
        if (s0.backEdge instanceof StreetTransitEntityLink && ((StreetTransitEntityLink)s0.backEdge).transitEntityVertex == this.transitEntityVertex) {
            return null;
        }
        RoutingPreferences pref = s0.getPreferences();
        StateEditor s1 = s0.edit(this);
        if (s0.getRequest().wheelchair()) {
            WheelchairPreferences accessibility = pref.wheelchair();
            if (accessibility.stop().onlyConsiderAccessible() && this.wheelchairAccessibility != Accessibility.POSSIBLE) {
                return null;
            }
            if (this.wheelchairAccessibility == Accessibility.NO_INFORMATION) {
                s1.incrementWeight(accessibility.stop().unknownCost());
            } else if (this.wheelchairAccessibility == Accessibility.NOT_POSSIBLE) {
                s1.incrementWeight(accessibility.stop().inaccessibleCost());
            }
        }
        switch (s0.getNonTransitMode()) {
            case BICYCLE: {
                if (s0.getRequest().mode().includesParking() && !s0.isVehicleParked()) {
                    return null;
                }
                if (!s0.isRentingVehicleFromStation() || s0.mayKeepRentedVehicleAtDestination() && s0.getRequest().rental().allowArrivingInRentedVehicleAtDestination()) break;
                return null;
            }
            case CAR: {
                if (s0.getRequest().mode().includesParking() && !s0.isVehicleParked()) {
                    return null;
                }
                if (s0.getCarPickupState() == null) break;
                if (this.canDropOffAfterDriving(s0) && this.isLeavingStreetNetwork(s0.getRequest().arriveBy())) {
                    this.dropOffAfterDriving(s0, s1);
                    break;
                }
                return null;
            }
            case WALK: {
                break;
            }
            default: {
                return null;
            }
        }
        if (s0.isRentingVehicleFromStation() && s0.mayKeepRentedVehicleAtDestination() && s0.getRequest().rental().allowArrivingInRentedVehicleAtDestination()) {
            s1.incrementWeight(pref.rental().arrivingInRentalVehicleAtDestinationCost());
        }
        s1.setBackMode(null);
        int streetToStopTime = this.getStreetToStopTime();
        s1.incrementTimeInSeconds(streetToStopTime);
        s1.incrementWeight(1 + streetToStopTime);
        return s1.makeState();
    }

    @Override
    public I18NString getName() {
        return ((Vertex)this.transitEntityVertex).getName();
    }

    @Override
    public LineString getGeometry() {
        Coordinate[] coordinates = new Coordinate[]{this.fromv.getCoordinate(), this.tov.getCoordinate()};
        return GeometryUtils.getGeometryFactory().createLineString(coordinates);
    }

    @Override
    public double getDistanceMeters() {
        return 0.0;
    }

    protected abstract int getStreetToStopTime();

    protected T getTransitEntityVertex() {
        return this.transitEntityVertex;
    }

    boolean isLeavingStreetNetwork(boolean arriveBy) {
        return (arriveBy ? this.fromv : this.tov) == this.getTransitEntityVertex();
    }
}

