/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.edge;

import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.routing.api.request.preference.WheelchairPreferences;
import org.opentripplanner.street.search.TraverseMode;

class StreetEdgeReluctanceCalculator {
    private StreetEdgeReluctanceCalculator() {
    }

    static double computeReluctance(RoutingPreferences pref, TraverseMode traverseMode, boolean walkingBike, boolean edgeIsStairs) {
        if (edgeIsStairs) {
            return pref.walk().stairsReluctance();
        }
        return switch (traverseMode) {
            case TraverseMode.WALK -> {
                if (walkingBike) {
                    yield pref.bike().walkingReluctance();
                }
                yield pref.walk().reluctance();
            }
            case TraverseMode.BICYCLE -> pref.bike().reluctance();
            case TraverseMode.CAR -> pref.car().reluctance();
            default -> throw new IllegalArgumentException("getReluctance(): Invalid mode " + traverseMode);
        };
    }

    static double computeWheelchairReluctance(RoutingPreferences preferences, double maxSlope, boolean edgeWheelchairAccessible, boolean stairs) {
        double slopeExceededReluctance;
        double slopeExceededBy;
        WheelchairPreferences wheelchair = preferences.wheelchair();
        double reluctance = edgeWheelchairAccessible ? 1.0 : wheelchair.inaccessibleStreetReluctance();
        reluctance *= preferences.walk().reluctance();
        if (stairs) {
            reluctance *= wheelchair.stairsReluctance();
        }
        if ((slopeExceededBy = Math.abs(maxSlope) - wheelchair.maxSlope()) > 0.0 && (slopeExceededReluctance = wheelchair.slopeExceededReluctance()) > 0.0) {
            reluctance *= 1.0 + 100.0 * slopeExceededBy * slopeExceededReluctance;
        }
        return reluctance;
    }
}

