/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.edge;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;
import org.opentripplanner.framework.geometry.CompactLineStringUtils;
import org.opentripplanner.framework.geometry.DirectionUtils;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.geometry.SphericalDistanceLibrary;
import org.opentripplanner.framework.geometry.SplitLineString;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.framework.lang.BitSetUtils;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.routing.linking.DisposableEdgeCollection;
import org.opentripplanner.routing.linking.LinkingDirection;
import org.opentripplanner.routing.util.ElevationUtils;
import org.opentripplanner.street.model.RentalRestrictionExtension;
import org.opentripplanner.street.model.StreetTraversalPermission;
import org.opentripplanner.street.model.TurnRestriction;
import org.opentripplanner.street.model.TurnRestrictionType;
import org.opentripplanner.street.model.edge.BikeWalkableEdge;
import org.opentripplanner.street.model.edge.CarPickupableEdge;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.SplitStreetEdge;
import org.opentripplanner.street.model.edge.StreetEdgeCostExtension;
import org.opentripplanner.street.model.edge.StreetEdgeReluctanceCalculator;
import org.opentripplanner.street.model.edge.StreetElevationExtension;
import org.opentripplanner.street.model.edge.TemporaryPartialStreetEdge;
import org.opentripplanner.street.model.edge.WheelchairTraversalInformation;
import org.opentripplanner.street.model.vertex.BarrierVertex;
import org.opentripplanner.street.model.vertex.IntersectionVertex;
import org.opentripplanner.street.model.vertex.SplitterVertex;
import org.opentripplanner.street.model.vertex.StreetVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.TraverseModeSet;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.street.search.state.StateEditor;
import org.opentripplanner.street.search.state.VehicleRentalState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreetEdge
extends Edge
implements BikeWalkableEdge,
Cloneable,
CarPickupableEdge,
WheelchairTraversalInformation {
    private static final Logger LOG = LoggerFactory.getLogger(StreetEdge.class);
    private static final double GREENWAY_SAFETY_FACTOR = 0.1;
    public static final float DEFAULT_CAR_SPEED = 11.2f;
    private static final int BACK_FLAG_INDEX = 0;
    private static final int ROUNDABOUT_FLAG_INDEX = 1;
    private static final int HASBOGUSNAME_FLAG_INDEX = 2;
    private static final int MOTOR_VEHICLE_NOTHRUTRAFFIC = 3;
    private static final int STAIRS_FLAG_INDEX = 4;
    private static final int SLOPEOVERRIDE_FLAG_INDEX = 5;
    private static final int WHEELCHAIR_ACCESSIBLE_FLAG_INDEX = 6;
    private static final int BICYCLE_NOTHRUTRAFFIC = 7;
    private static final int WALK_NOTHRUTRAFFIC = 8;
    private static final int CLASS_LINK = 9;
    private StreetEdgeCostExtension costExtension;
    private short flags;
    private int length_mm;
    protected float bicycleSafetyFactor;
    protected float walkSafetyFactor;
    private byte[] compactGeometry;
    private I18NString name;
    private StreetTraversalPermission permission;
    private float carSpeed;
    private byte inAngle;
    private byte outAngle;
    private StreetElevationExtension elevationExtension;
    private List<TurnRestriction> turnRestrictions = Collections.emptyList();

    public StreetEdge(StreetVertex v1, StreetVertex v2, LineString geometry, I18NString name, double length, StreetTraversalPermission permission, boolean back) {
        super(v1, v2);
        this.setBack(back);
        this.setGeometry(geometry);
        this.length_mm = (int)(length * 1000.0);
        if (this.length_mm == 0) {
            LOG.warn("StreetEdge {} from {} to {} has length of 0. This is usually an error.", new Object[]{name, v1, v2});
        }
        this.bicycleSafetyFactor = 1.0f;
        this.walkSafetyFactor = 1.0f;
        this.name = name;
        this.setPermission(permission);
        this.setCarSpeed(11.2f);
        this.setWheelchairAccessible(true);
        if (geometry != null) {
            try {
                for (Coordinate c : geometry.getCoordinates()) {
                    if (Double.isNaN(c.x)) {
                        System.out.println("X DOOM");
                    }
                    if (!Double.isNaN(c.y)) continue;
                    System.out.println("Y DOOM");
                }
                double angleRadians = DirectionUtils.getLastAngle((Geometry)geometry);
                this.outAngle = (byte)Math.round(angleRadians * 128.0 / Math.PI + 128.0);
                angleRadians = DirectionUtils.getFirstAngle((Geometry)geometry);
                this.inAngle = (byte)Math.round(angleRadians * 128.0 / Math.PI + 128.0);
            }
            catch (IllegalArgumentException iae) {
                LOG.error("exception while determining street edge angles. setting to zero. there is probably something wrong with this street segment's geometry.");
                this.inAngle = 0;
                this.outAngle = 0;
            }
        }
    }

    public StreetEdge(StreetVertex v1, StreetVertex v2, LineString geometry, String name, double length, StreetTraversalPermission permission, boolean back) {
        this(v1, v2, geometry, new NonLocalizedString(name), length, permission, back);
    }

    public StreetEdge(StreetVertex v1, StreetVertex v2, LineString geometry, I18NString name, StreetTraversalPermission permission, boolean back) {
        this(v1, v2, geometry, name, SphericalDistanceLibrary.length(geometry), permission, back);
    }

    public boolean canTraverse(TraverseModeSet modes) {
        return this.getPermission().allows(modes);
    }

    public boolean canTraverse(TraverseMode mode) {
        StreetTraversalPermission permission = this.getPermission();
        if (this.fromv instanceof BarrierVertex) {
            permission = permission.intersection(((BarrierVertex)this.fromv).getBarrierPermissions());
        }
        if (this.tov instanceof BarrierVertex) {
            permission = permission.intersection(((BarrierVertex)this.tov).getBarrierPermissions());
        }
        return permission.allows(mode);
    }

    public void setElevationExtension(StreetElevationExtension streetElevationExtension) {
        this.elevationExtension = streetElevationExtension;
    }

    public boolean hasElevationExtension() {
        return this.elevationExtension != null;
    }

    public PackedCoordinateSequence getElevationProfile() {
        return this.hasElevationExtension() ? this.elevationExtension.getElevationProfile() : null;
    }

    public boolean isElevationFlattened() {
        return this.hasElevationExtension() && this.elevationExtension.isFlattened();
    }

    public double getMaxSlope() {
        return this.hasElevationExtension() ? (double)this.elevationExtension.getMaxSlope() : 0.0;
    }

    public boolean isNoThruTraffic(TraverseMode traverseMode) {
        return switch (traverseMode) {
            default -> throw new IncompatibleClassChangeError();
            case TraverseMode.WALK -> this.isWalkNoThruTraffic();
            case TraverseMode.BICYCLE, TraverseMode.SCOOTER -> this.isBicycleNoThruTraffic();
            case TraverseMode.CAR, TraverseMode.FLEX -> this.isMotorVehicleNoThruTraffic();
        };
    }

    public double calculateSpeed(RoutingPreferences preferences, TraverseMode traverseMode, boolean walkingBike) {
        if (traverseMode == null) {
            return Double.NaN;
        }
        double speed = switch (traverseMode) {
            default -> throw new IncompatibleClassChangeError();
            case TraverseMode.WALK -> {
                if (walkingBike) {
                    yield preferences.bike().walkingSpeed();
                }
                yield preferences.walk().speed();
            }
            case TraverseMode.BICYCLE, TraverseMode.SCOOTER -> preferences.bike().speed();
            case TraverseMode.CAR -> this.getCarSpeed();
            case TraverseMode.FLEX -> throw new IllegalArgumentException("getSpeed(): Invalid mode " + traverseMode);
        };
        return this.isStairs() ? speed / preferences.walk().stairsTimeFactor() : speed;
    }

    public double getEffectiveBikeDistance() {
        return this.hasElevationExtension() ? this.elevationExtension.getEffectiveBikeDistance() : this.getDistanceMeters();
    }

    public double getEffectiveBikeDistanceForWorkCost() {
        return this.hasElevationExtension() ? this.elevationExtension.getEffectiveBikeDistanceForWorkCost() : this.getDistanceMeters();
    }

    public float getBicycleSafetyFactor() {
        return this.bicycleSafetyFactor;
    }

    public void setBicycleSafetyFactor(float bicycleSafetyFactor) {
        if (this.hasElevationExtension()) {
            throw new IllegalStateException("A bicycle safety factor may not be set if an elevation extension is set.");
        }
        if (!Float.isFinite(bicycleSafetyFactor) || bicycleSafetyFactor <= 0.0f) {
            throw new IllegalArgumentException("Invalid bicycleSafetyFactor: " + bicycleSafetyFactor);
        }
        this.bicycleSafetyFactor = bicycleSafetyFactor;
    }

    public double getEffectiveBicycleSafetyDistance() {
        return this.elevationExtension != null ? this.elevationExtension.getEffectiveBicycleSafetyDistance() : (double)this.bicycleSafetyFactor * this.getDistanceMeters();
    }

    public float getWalkSafetyFactor() {
        return this.walkSafetyFactor;
    }

    public void setWalkSafetyFactor(float walkSafetyFactor) {
        if (this.hasElevationExtension()) {
            throw new IllegalStateException("A walk safety factor may not be set if an elevation extension is set.");
        }
        if (!Float.isFinite(walkSafetyFactor) || walkSafetyFactor <= 0.0f) {
            throw new IllegalArgumentException("Invalid walkSafetyFactor: " + walkSafetyFactor);
        }
        this.walkSafetyFactor = walkSafetyFactor;
    }

    public double getEffectiveWalkSafetyDistance() {
        return this.elevationExtension != null ? this.elevationExtension.getEffectiveWalkSafetyDistance() : (double)this.walkSafetyFactor * this.getDistanceMeters();
    }

    @Override
    public String toString() {
        return "StreetEdge(" + this.name + ", " + this.fromv + " -> " + this.tov + " length=" + this.getDistanceMeters() + " carSpeed=" + this.getCarSpeed() + " permission=" + this.getPermission() + ")";
    }

    @Override
    public boolean isRoundabout() {
        return BitSetUtils.get(this.flags, 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public State traverse(State s0) {
        StateEditor dropOff;
        StateEditor inCar;
        StateEditor afterTraversal;
        State state;
        StateEditor editor;
        boolean arriveByRental;
        boolean bl = arriveByRental = s0.getRequest().mode().includesRenting() && s0.getRequest().arriveBy();
        if (arriveByRental && (this.tov.rentalTraversalBanned(s0) || this.hasStartedSearchInNoDropOffZoneAndIsExitingIt(s0))) {
            return null;
        }
        if (s0.getRequest().mode().includesRenting() && this.tov.rentalTraversalBanned(s0)) {
            editor = this.doTraverse(s0, TraverseMode.WALK, false);
            if (editor != null) {
                editor.dropFloatingVehicle(s0.vehicleRentalFormFactor(), s0.getVehicleRentalNetwork(), s0.getRequest().arriveBy());
            }
        } else if (arriveByRental && this.leavesZoneWithRentalRestrictionsWhenHavingRented(s0)) {
            editor = this.doTraverse(s0, TraverseMode.WALK, false);
            if (editor != null) {
                editor.dropFloatingVehicle(s0.vehicleRentalFormFactor(), s0.getVehicleRentalNetwork(), s0.getRequest().arriveBy());
                editor.resetStartedInNoDropOffZone();
            }
        } else if (s0.getNonTransitMode() == TraverseMode.BICYCLE) {
            if (this.canTraverse(TraverseMode.BICYCLE)) {
                editor = this.doTraverse(s0, TraverseMode.BICYCLE, false);
            } else {
                if (!this.canTraverse(TraverseMode.WALK)) return null;
                editor = this.doTraverse(s0, TraverseMode.WALK, true);
            }
        } else {
            editor = this.canTraverse(s0.getNonTransitMode()) ? this.doTraverse(s0, s0.getNonTransitMode(), false) : null;
        }
        State state2 = state = editor != null ? editor.makeState() : null;
        if (state != null && !this.fromv.rentalDropOffBanned(s0) && this.tov.rentalDropOffBanned(s0) && (afterTraversal = this.doTraverse(s0, TraverseMode.WALK, false)) != null) {
            afterTraversal.dropFloatingVehicle(state.vehicleRentalFormFactor(), state.getVehicleRentalNetwork(), state.getRequest().arriveBy());
            afterTraversal.leaveNoRentalDropOffArea();
            State forkState = afterTraversal.makeState();
            forkState.addToExistingResultChain(state);
            return forkState;
        }
        if (state != null && arriveByRental && this.leavesZoneWithRentalRestrictionsWhenHavingRented(s0)) {
            StateEditor walking = this.doTraverse(s0, TraverseMode.WALK, false);
            State forkState = walking.makeState();
            forkState.addToExistingResultChain(state);
            return forkState;
        }
        if (this.canPickupAndDrive(s0) && this.canTraverse(TraverseMode.CAR) && (inCar = this.doTraverse(s0, TraverseMode.CAR, false)) != null) {
            this.driveAfterPickup(s0, inCar);
            State forkState = inCar.makeState();
            if (forkState != null) {
                forkState.addToExistingResultChain(state);
                return forkState;
            }
        }
        if (!this.canDropOffAfterDriving(s0) || this.getPermission().allows(TraverseMode.CAR) || !this.canTraverse(TraverseMode.WALK) || (dropOff = this.doTraverse(s0, TraverseMode.WALK, false)) == null) return state;
        this.dropOffAfterDriving(s0, dropOff);
        return dropOff.makeState();
    }

    private boolean leavesZoneWithRentalRestrictionsWhenHavingRented(State s0) {
        return s0.getVehicleRentalState() == VehicleRentalState.HAVE_RENTED && !this.fromv.rentalRestrictions().hasRestrictions() && this.tov.rentalRestrictions().hasRestrictions();
    }

    private boolean hasStartedSearchInNoDropOffZoneAndIsExitingIt(State s0) {
        return s0.isRentingVehicle() && !this.fromv.rentalDropOffBanned(s0) && this.tov.rentalDropOffBanned(s0) && !s0.stateData.noRentalDropOffZonesAtStartOfReverseSearch.isEmpty();
    }

    @Override
    public I18NString getName() {
        return this.name;
    }

    public void setName(I18NString name) {
        this.name = name;
    }

    @Override
    public boolean hasBogusName() {
        return BitSetUtils.get(this.flags, 2);
    }

    @Override
    public LineString getGeometry() {
        return CompactLineStringUtils.uncompactLineString(this.fromv.getLon(), this.fromv.getLat(), this.tov.getLon(), this.tov.getLat(), this.compactGeometry, this.isBack());
    }

    @Override
    public double getDistanceMeters() {
        return (double)this.length_mm / 1000.0;
    }

    @Override
    public double getEffectiveWalkDistance() {
        return this.hasElevationExtension() ? this.elevationExtension.getEffectiveWalkDistance() : this.getDistanceMeters();
    }

    public void removeRentalExtension(RentalRestrictionExtension ext) {
        this.fromv.removeRentalRestriction(ext);
        this.tov.removeRentalRestriction(ext);
    }

    private void setGeometry(LineString geometry) {
        this.compactGeometry = CompactLineStringUtils.compactLineString(this.fromv.getLon(), this.fromv.getLat(), this.tov.getLon(), this.tov.getLat(), this.isBack() ? geometry.reverse() : geometry, this.isBack());
    }

    public void setRoundabout(boolean roundabout) {
        this.flags = BitSetUtils.set(this.flags, 1, roundabout);
    }

    public StreetEdge clone() {
        try {
            return (StreetEdge)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean canTurnOnto(Edge e, State state, TraverseMode mode) {
        for (TurnRestriction turnRestriction : this.turnRestrictions) {
            if (!(turnRestriction.type == TurnRestrictionType.ONLY_TURN ? !e.isEquivalentTo(turnRestriction.to) && turnRestriction.modes.contains(mode) && turnRestriction.active(state.getTimeSeconds()) : e.isEquivalentTo(turnRestriction.to) && turnRestriction.modes.contains(mode) && turnRestriction.active(state.getTimeSeconds()))) continue;
            return false;
        }
        return true;
    }

    public void shareData(StreetEdge reversedEdge) {
        if (Arrays.equals(this.compactGeometry, reversedEdge.compactGeometry)) {
            this.compactGeometry = reversedEdge.compactGeometry;
        } else {
            LOG.warn("Can't share geometry between {} and {}", (Object)this, (Object)reversedEdge);
        }
    }

    @Override
    public boolean isWheelchairAccessible() {
        return BitSetUtils.get(this.flags, 6);
    }

    public void setWheelchairAccessible(boolean wheelchairAccessible) {
        this.flags = BitSetUtils.set(this.flags, 6, wheelchairAccessible);
    }

    public StreetTraversalPermission getPermission() {
        return this.permission;
    }

    public void setPermission(StreetTraversalPermission permission) {
        this.permission = permission;
    }

    public boolean isBack() {
        return BitSetUtils.get(this.flags, 0);
    }

    public void setBack(boolean back) {
        this.flags = BitSetUtils.set(this.flags, 0, back);
    }

    public void setHasBogusName(boolean hasBogusName) {
        this.flags = BitSetUtils.set(this.flags, 2, hasBogusName);
    }

    public boolean isWalkNoThruTraffic() {
        return BitSetUtils.get(this.flags, 8);
    }

    public void setWalkNoThruTraffic(boolean noThruTraffic) {
        this.flags = BitSetUtils.set(this.flags, 8, noThruTraffic);
    }

    public boolean isMotorVehicleNoThruTraffic() {
        return BitSetUtils.get(this.flags, 3);
    }

    public void setMotorVehicleNoThruTraffic(boolean noThruTraffic) {
        this.flags = BitSetUtils.set(this.flags, 3, noThruTraffic);
    }

    public boolean isBicycleNoThruTraffic() {
        return BitSetUtils.get(this.flags, 7);
    }

    public void setBicycleNoThruTraffic(boolean noThruTraffic) {
        this.flags = BitSetUtils.set(this.flags, 7, noThruTraffic);
    }

    public boolean isStairs() {
        return BitSetUtils.get(this.flags, 4);
    }

    public void setStairs(boolean stairs) {
        this.flags = BitSetUtils.set(this.flags, 4, stairs);
    }

    public boolean isLink() {
        return BitSetUtils.get(this.flags, 9);
    }

    public void setLink(boolean link) {
        this.flags = BitSetUtils.set(this.flags, 9, link);
    }

    public float getCarSpeed() {
        return this.carSpeed;
    }

    public void setCarSpeed(float carSpeed) {
        this.carSpeed = carSpeed;
    }

    public boolean isSlopeOverride() {
        return BitSetUtils.get(this.flags, 5);
    }

    public void setSlopeOverride(boolean slopeOverride) {
        this.flags = BitSetUtils.set(this.flags, 5, slopeOverride);
    }

    public int getInAngle() {
        return (int)Math.round((double)(this.inAngle * 180) / 128.0);
    }

    public int getOutAngle() {
        return (int)Math.round((double)(this.outAngle * 180) / 128.0);
    }

    public void setCostExtension(StreetEdgeCostExtension costExtension) {
        this.costExtension = costExtension;
    }

    public void addRentalRestriction(RentalRestrictionExtension ext) {
        this.fromv.addRentalRestriction(ext);
    }

    public SplitStreetEdge splitDestructively(SplitterVertex v) {
        SplitLineString geoms = GeometryUtils.splitGeometryAtPoint((Geometry)this.getGeometry(), v.getCoordinate());
        StreetEdge e1 = new StreetEdge((StreetVertex)this.fromv, v, geoms.beginning(), this.name, this.permission, this.isBack());
        StreetEdge e2 = new StreetEdge(v, (StreetVertex)this.tov, geoms.ending(), this.name, this.permission, this.isBack());
        if (!this.isBack()) {
            frac = (double)e1.length_mm / (double)(e1.length_mm + e2.length_mm);
            e1.length_mm = (int)((double)this.length_mm * frac);
            e2.length_mm = this.length_mm - e1.length_mm;
        } else {
            frac = (double)e2.length_mm / (double)(e1.length_mm + e2.length_mm);
            e2.length_mm = (int)((double)this.length_mm * frac);
            e1.length_mm = this.length_mm - e2.length_mm;
        }
        if (e1.length_mm <= 0) {
            LOG.error("Edge 1 ({}) split at vertex at {},{} has length {} mm. Setting to 1 mm.", new Object[]{e1.getName(), v.getLat(), v.getLon(), e1.length_mm});
            e1.length_mm = 1;
        }
        if (e2.length_mm <= 0) {
            LOG.error("Edge 2 ({}) split at vertex at {},{}  has length {} mm. Setting to 1 mm.", new Object[]{e2.getName(), v.getLat(), v.getLon(), e2.length_mm});
            e2.length_mm = 1;
        }
        if (e1.length_mm < 0 || e2.length_mm < 0) {
            e1.tov.removeIncoming(e1);
            e1.fromv.removeOutgoing(e1);
            e2.tov.removeIncoming(e2);
            e2.fromv.removeOutgoing(e2);
            throw new IllegalStateException("Split street is longer than original street!");
        }
        this.copyPropertiesToSplitEdge(e1, 0.0, e1.getDistanceMeters());
        this.copyPropertiesToSplitEdge(e2, e1.getDistanceMeters(), this.getDistanceMeters());
        SplitStreetEdge splitEdges = new SplitStreetEdge(e1, e2);
        StreetEdge.copyRestrictionsToSplitEdges(this, splitEdges);
        return splitEdges;
    }

    public SplitStreetEdge splitNonDestructively(SplitterVertex v, DisposableEdgeCollection tempEdges, LinkingDirection direction) {
        SplitLineString geoms = GeometryUtils.splitGeometryAtPoint((Geometry)this.getGeometry(), v.getCoordinate());
        TemporaryPartialStreetEdge e1 = null;
        TemporaryPartialStreetEdge e2 = null;
        if (direction == LinkingDirection.OUTGOING || direction == LinkingDirection.BOTH_WAYS) {
            e1 = new TemporaryPartialStreetEdge(this, (StreetVertex)this.fromv, (StreetVertex)v, geoms.beginning(), this.name, this.isBack());
            this.copyPropertiesToSplitEdge(e1, 0.0, e1.getDistanceMeters());
            tempEdges.addEdge(e1);
        }
        if (direction == LinkingDirection.INCOMING || direction == LinkingDirection.BOTH_WAYS) {
            e2 = new TemporaryPartialStreetEdge(this, (StreetVertex)v, (StreetVertex)this.tov, geoms.ending(), this.name, this.isBack());
            this.copyPropertiesToSplitEdge(e2, this.getDistanceMeters() - e2.getDistanceMeters(), this.getDistanceMeters());
            tempEdges.addEdge(e2);
        }
        SplitStreetEdge splitEdges = new SplitStreetEdge(e1, e2);
        StreetEdge.copyRestrictionsToSplitEdges(this, splitEdges);
        return splitEdges;
    }

    public Optional<Edge> createPartialEdge(StreetVertex from, StreetVertex to) {
        LineString parent = this.getGeometry();
        LineString head = GeometryUtils.getInteriorSegment((Geometry)parent, this.getFromVertex().getCoordinate(), from.getCoordinate());
        LineString tail = GeometryUtils.getInteriorSegment((Geometry)parent, to.getCoordinate(), this.getToVertex().getCoordinate());
        if (parent.getLength() > head.getLength() + tail.getLength()) {
            LineString partial = GeometryUtils.getInteriorSegment((Geometry)parent, from.getCoordinate(), to.getCoordinate());
            double startRatio = head.getLength() / parent.getLength();
            double start = this.getDistanceMeters() * startRatio;
            double lengthRatio = partial.getLength() / parent.getLength();
            double length = this.getDistanceMeters() * lengthRatio;
            TemporaryPartialStreetEdge tempEdge = new TemporaryPartialStreetEdge(this, from, to, partial, this.getName(), length);
            this.copyPropertiesToSplitEdge(tempEdge, start, start + length);
            return Optional.of(tempEdge);
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTurnRestriction(TurnRestriction turnRestriction) {
        if (turnRestriction == null) {
            return;
        }
        StreetEdge streetEdge = this;
        synchronized (streetEdge) {
            HashSet<TurnRestriction> temp = new HashSet<TurnRestriction>(this.turnRestrictions);
            temp.add(turnRestriction);
            this.turnRestrictions = List.copyOf(temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTurnRestriction(TurnRestriction turnRestriction) {
        if (turnRestriction == null) {
            return;
        }
        StreetEdge streetEdge = this;
        synchronized (streetEdge) {
            if (this.turnRestrictions.contains(turnRestriction)) {
                if (this.turnRestrictions.size() == 1) {
                    this.turnRestrictions = Collections.emptyList();
                } else {
                    HashSet<TurnRestriction> withRemoved = new HashSet<TurnRestriction>(this.turnRestrictions);
                    withRemoved.remove(turnRestriction);
                    this.turnRestrictions = List.copyOf(withRemoved);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllTurnRestrictions() {
        if (this.turnRestrictions == null) {
            return;
        }
        StreetEdge streetEdge = this;
        synchronized (streetEdge) {
            this.turnRestrictions = Collections.emptyList();
        }
    }

    @Override
    public void removeTurnRestrictionsTo(Edge other) {
        for (TurnRestriction turnRestriction : this.getTurnRestrictions()) {
            if (turnRestriction.to != other) continue;
            this.removeTurnRestriction(turnRestriction);
        }
    }

    @Nonnull
    public List<TurnRestriction> getTurnRestrictions() {
        return this.turnRestrictions;
    }

    @Override
    public void remove() {
        this.removeAllTurnRestrictions();
        super.remove();
    }

    protected void copyPropertiesToSplitEdge(StreetEdge splitEdge, double fromDistance, double toDistance) {
        splitEdge.flags = this.flags;
        splitEdge.setBicycleSafetyFactor(this.bicycleSafetyFactor);
        splitEdge.setWalkSafetyFactor(this.walkSafetyFactor);
        splitEdge.setLink(this.isLink());
        splitEdge.setCarSpeed(this.getCarSpeed());
        splitEdge.setElevationExtensionUsingParent(this, fromDistance, toDistance);
        splitEdge.addRentalRestriction(this.fromv.rentalRestrictions());
    }

    protected void setElevationExtensionUsingParent(StreetEdge parentEdge, double fromDistance, double toDistance) {
        PackedCoordinateSequence profile = ElevationUtils.getPartialElevationProfile(parentEdge.getElevationProfile(), fromDistance, toDistance);
        StreetElevationExtension.addToEdge(this, profile, true);
    }

    private static void copyRestrictionsToSplitEdges(StreetEdge edge, SplitStreetEdge splitEdges) {
        if (splitEdges.head() != null) {
            edge.getFromVertex().getIncoming().stream().filter(StreetEdge.class::isInstance).map(StreetEdge.class::cast).flatMap(originatingEdge -> originatingEdge.getTurnRestrictions().stream()).filter(restriction -> restriction.to == edge).forEach(restriction -> StreetEdge.applyRestrictionsToNewEdge(restriction.from, splitEdges.head(), restriction));
        }
        if (splitEdges.tail() != null) {
            edge.getTurnRestrictions().forEach(existingTurnRestriction -> StreetEdge.applyRestrictionsToNewEdge(splitEdges.tail(), existingTurnRestriction.to, existingTurnRestriction));
        }
    }

    private static void applyRestrictionsToNewEdge(StreetEdge fromEdge, StreetEdge toEdge, TurnRestriction restriction) {
        TurnRestriction splitTurnRestriction = new TurnRestriction(fromEdge, toEdge, restriction.type, restriction.modes, restriction.time);
        LOG.debug("Created new restriction for split edges: {}", (Object)splitTurnRestriction);
        fromEdge.addTurnRestriction(splitTurnRestriction);
    }

    private double getDistanceWithElevation() {
        return this.hasElevationExtension() ? this.elevationExtension.getDistanceWithElevation() : this.getDistanceMeters();
    }

    private StateEditor doTraverse(State s0, TraverseMode traverseMode, boolean walkingBike) {
        Edge backEdge = s0.getBackEdge();
        if (backEdge != null && (this.isReverseOf(backEdge) || backEdge.isReverseOf(this))) {
            return null;
        }
        StateEditor s1 = this.createEditor(s0, this, traverseMode, walkingBike);
        if (this.isTraversalBlockedByNoThruTraffic(traverseMode, backEdge, s0, s1)) {
            return null;
        }
        if (s0.getRequest().mode().includesRenting()) {
            if (this.tov.rentalDropOffBanned(s0)) {
                s1.enterNoRentalDropOffArea();
            } else if (s0.isInsideNoRentalDropOffArea() && !this.tov.rentalDropOffBanned(s0)) {
                s1.leaveNoRentalDropOffArea();
            }
        }
        RoutingPreferences preferences = s0.getPreferences();
        double speed = this.calculateSpeed(preferences, traverseMode, walkingBike);
        TraversalCosts traversalCosts = switch (traverseMode) {
            case TraverseMode.BICYCLE, TraverseMode.SCOOTER -> this.bicycleTraversalCost(preferences, speed);
            case TraverseMode.WALK -> this.walkingTraversalCosts(preferences, traverseMode, speed, walkingBike, s0.getRequest().wheelchair());
            default -> this.otherTraversalCosts(preferences, traverseMode, walkingBike, speed);
        };
        int time = (int)Math.ceil(traversalCosts.time());
        double weight = traversalCosts.weight();
        if (backEdge instanceof StreetEdge) {
            double turnDuration;
            Vertex vertex;
            StreetEdge backPSE = (StreetEdge)backEdge;
            TraverseMode backMode = s0.getBackMode();
            boolean arriveBy = s0.getRequest().arriveBy();
            if (arriveBy ? !this.canTurnOnto(backPSE, s0, backMode) : !backPSE.canTurnOnto(this, s0, traverseMode)) {
                return null;
            }
            double backSpeed = backPSE.calculateSpeed(preferences, backMode, s0.isBackWalkingBike());
            if (arriveBy && (vertex = this.tov) instanceof IntersectionVertex) {
                IntersectionVertex traversedVertex = (IntersectionVertex)vertex;
                turnDuration = s0.intersectionTraversalCalculator().computeTraversalDuration(traversedVertex, this, backPSE, backMode, (float)speed, (float)backSpeed);
            } else if (!arriveBy && (vertex = this.fromv) instanceof IntersectionVertex) {
                IntersectionVertex traversedVertex = (IntersectionVertex)vertex;
                turnDuration = s0.intersectionTraversalCalculator().computeTraversalDuration(traversedVertex, backPSE, this, traverseMode, (float)backSpeed, (float)speed);
            } else {
                LOG.debug("Not computing turn duration for edge {}", (Object)this);
                turnDuration = 0.0;
            }
            if (!traverseMode.isDriving()) {
                s1.incrementWalkDistance(turnDuration / 100.0);
            }
            time += (int)Math.ceil(turnDuration);
            weight += preferences.street().turnReluctance() * turnDuration;
        }
        if (!traverseMode.isDriving()) {
            s1.incrementWalkDistance(this.getDistanceWithElevation());
        }
        if (this.costExtension != null) {
            weight += this.costExtension.calculateExtraCost(s0, this.length_mm, traverseMode);
        }
        s1.incrementTimeInSeconds(time);
        s1.incrementWeight(weight);
        return s1;
    }

    @Nonnull
    private TraversalCosts otherTraversalCosts(RoutingPreferences preferences, TraverseMode traverseMode, boolean walkingBike, double speed) {
        double time = this.getDistanceMeters() / speed;
        double weight = time * StreetEdgeReluctanceCalculator.computeReluctance(preferences, traverseMode, walkingBike, this.isStairs());
        return new TraversalCosts(time, weight);
    }

    @Nonnull
    private TraversalCosts bicycleTraversalCost(RoutingPreferences pref, double speed) {
        double time = this.getEffectiveBikeDistance() / speed;
        switch (pref.bike().optimizeType()) {
            case GREENWAYS: {
                double weight = (double)this.bicycleSafetyFactor * this.getDistanceMeters() / speed;
                if (!((double)this.bicycleSafetyFactor <= 0.1)) break;
                weight *= 0.66;
                break;
            }
            case SAFE: {
                double weight = this.getEffectiveBicycleSafetyDistance() / speed;
                break;
            }
            case FLAT: {
                double weight = this.getEffectiveBikeDistanceForWorkCost() / speed;
                break;
            }
            case QUICK: {
                double weight = this.getEffectiveBikeDistance() / speed;
                break;
            }
            case TRIANGLE: {
                double quick = this.getEffectiveBikeDistance();
                double safety = this.getEffectiveBicycleSafetyDistance();
                double slope = this.getEffectiveBikeDistanceForWorkCost();
                double weight = quick * pref.bike().optimizeTriangle().time() + slope * pref.bike().optimizeTriangle().slope() + safety * pref.bike().optimizeTriangle().safety();
                weight /= speed;
                break;
            }
            default: {
                double weight = this.getDistanceMeters() / speed;
            }
        }
        double reluctance = StreetEdgeReluctanceCalculator.computeReluctance(pref, TraverseMode.BICYCLE, false, this.isStairs());
        return new TraversalCosts(time, weight *= reluctance);
    }

    @Nonnull
    private TraversalCosts walkingTraversalCosts(RoutingPreferences preferences, TraverseMode traverseMode, double speed, boolean walkingBike, boolean wheelchair) {
        double weight;
        double time;
        if (wheelchair) {
            time = this.getEffectiveWalkDistance() / speed;
            weight = this.getEffectiveBikeDistance() / speed * StreetEdgeReluctanceCalculator.computeWheelchairReluctance(preferences, this.getMaxSlope(), this.isWheelchairAccessible(), this.isStairs());
        } else {
            if (walkingBike) {
                time = weight = this.getEffectiveBikeDistance() / speed;
                if (this.isStairs()) {
                    weight *= preferences.bike().stairsReluctance();
                }
            } else {
                time = this.getEffectiveWalkDistance() / speed;
                weight = this.getEffectiveWalkSafetyDistance() * preferences.walk().safetyFactor() + this.getEffectiveWalkDistance() * (1.0 - preferences.walk().safetyFactor());
                weight /= speed;
            }
            weight *= StreetEdgeReluctanceCalculator.computeReluctance(preferences, traverseMode, walkingBike, this.isStairs());
        }
        return new TraversalCosts(time, weight);
    }

    private boolean isTraversalBlockedByNoThruTraffic(TraverseMode traverseMode, Edge backEdge, State s0, StateEditor s1) {
        if (this.isNoThruTraffic(traverseMode)) {
            StreetEdge sbe;
            if (backEdge instanceof StreetEdge && !(sbe = (StreetEdge)backEdge).isNoThruTraffic(traverseMode)) {
                s1.setEnteredNoThroughTrafficArea();
            }
        } else if (s0.hasEnteredNoThruTrafficArea()) {
            return true;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private record TraversalCosts(double time, double weight) {
    }
}

