/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.edge;

import java.util.Objects;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.street.model.edge.BikeWalkableEdge;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.StreetEdgeReluctanceCalculator;
import org.opentripplanner.street.model.edge.WheelchairTraversalInformation;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.street.search.state.StateEditor;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.PathwayMode;

public class PathwayEdge
extends Edge
implements BikeWalkableEdge,
WheelchairTraversalInformation {
    public static final I18NString DEFAULT_NAME = new NonLocalizedString("pathway");
    private final I18NString name;
    private final int traversalTime;
    private final double distance;
    private final int steps;
    private final double slope;
    private final PathwayMode mode;
    private final boolean wheelchairAccessible;
    private final FeedScopedId id;

    public PathwayEdge(Vertex fromv, Vertex tov, FeedScopedId id, I18NString name, int traversalTime, double distance, int steps, double slope, boolean wheelchairAccessible, PathwayMode mode) {
        super(fromv, tov);
        this.name = Objects.requireNonNullElse(name, DEFAULT_NAME);
        this.id = id;
        this.traversalTime = traversalTime;
        this.steps = steps;
        this.slope = slope;
        this.wheelchairAccessible = wheelchairAccessible;
        this.distance = distance;
        this.mode = mode;
    }

    public static PathwayEdge lowCost(Vertex fromV, Vertex toV, I18NString name, PathwayMode mode) {
        return PathwayEdge.lowCost(fromV, toV, null, name, true, mode);
    }

    public static PathwayEdge lowCost(Vertex fromV, Vertex toV, FeedScopedId id, I18NString name, boolean wheelchairAccessible, PathwayMode mode) {
        return new PathwayEdge(fromV, toV, id, name, 0, 0.0, 0, 0.0, wheelchairAccessible, mode);
    }

    @Override
    public State traverse(State s0) {
        StateEditor s1 = this.createEditorForWalking(s0, this);
        if (s1 == null) {
            return null;
        }
        RoutingPreferences preferences = s0.getPreferences();
        int time = this.traversalTime;
        if (time == 0) {
            if (this.distance > 0.0) {
                time = (int)(this.distance * preferences.walk().speed());
            } else if (this.isStairs()) {
                time = (int)(0.4 * (double)Math.abs(this.steps) * preferences.walk().speed());
            }
        }
        if (time > 0) {
            double weight = time;
            weight = s0.getRequest().wheelchair() ? (weight *= StreetEdgeReluctanceCalculator.computeWheelchairReluctance(preferences, this.slope, this.wheelchairAccessible, this.isStairs())) : (weight *= StreetEdgeReluctanceCalculator.computeReluctance(preferences, TraverseMode.WALK, s0.getNonTransitMode() == TraverseMode.BICYCLE, this.isStairs()));
            s1.incrementTimeInSeconds(time);
            s1.incrementWeight(weight);
        } else {
            s1.incrementWeight(1.0);
        }
        return s1.makeState();
    }

    @Override
    public I18NString getName() {
        return this.name;
    }

    @Override
    public boolean hasBogusName() {
        return this.name.equals(DEFAULT_NAME);
    }

    @Override
    public LineString getGeometry() {
        Coordinate[] coordinates = new Coordinate[]{this.getFromVertex().getCoordinate(), this.getToVertex().getCoordinate()};
        return GeometryUtils.getGeometryFactory().createLineString(coordinates);
    }

    @Override
    public double getDistanceMeters() {
        return this.distance;
    }

    @Override
    public double getEffectiveWalkDistance() {
        if (this.traversalTime > 0) {
            return 0.0;
        }
        return this.distance;
    }

    @Override
    public int getDistanceIndependentTime() {
        return this.traversalTime;
    }

    public int getSteps() {
        return this.steps;
    }

    public FeedScopedId getId() {
        return this.id;
    }

    @Override
    public boolean isWheelchairAccessible() {
        return this.wheelchairAccessible;
    }

    public PathwayMode getMode() {
        return this.mode;
    }

    private boolean isStairs() {
        return this.steps > 0;
    }
}

