/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.edge;

import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.framework.tostring.ToStringBuilder;
import org.opentripplanner.routing.api.request.preference.StreetPreferences;
import org.opentripplanner.street.model.edge.BikeWalkableEdge;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.ElevatorEdge;
import org.opentripplanner.street.model.vertex.ElevatorOffboardVertex;
import org.opentripplanner.street.model.vertex.ElevatorOnboardVertex;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.street.search.state.StateEditor;

public class ElevatorBoardEdge
extends Edge
implements BikeWalkableEdge,
ElevatorEdge {
    private final LineString geometry;

    public ElevatorBoardEdge(ElevatorOffboardVertex from, ElevatorOnboardVertex to) {
        super(from, to);
        this.geometry = GeometryUtils.makeLineString(List.of(new Coordinate(from.getX(), from.getY()), new Coordinate(to.getX(), to.getY())));
    }

    @Override
    public String toString() {
        return ToStringBuilder.of(this.getClass()).addObj("from", this.fromv).addObj("to", this.tov).toString();
    }

    @Override
    public State traverse(State s0) {
        StateEditor s1 = this.createEditorForDrivingOrWalking(s0, this);
        if (s1 == null) {
            return null;
        }
        StreetPreferences streetPreferences = s0.getPreferences().street();
        s1.incrementWeight(streetPreferences.elevator().boardCost());
        s1.incrementTimeInSeconds(streetPreferences.elevator().boardTime());
        return s1.makeState();
    }

    @Override
    public I18NString getName() {
        return new NonLocalizedString("Elevator");
    }

    @Override
    public boolean hasBogusName() {
        return true;
    }

    @Override
    public LineString getGeometry() {
        return this.geometry;
    }

    @Override
    public double getDistanceMeters() {
        return 0.0;
    }
}

