/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.street.model.edge;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.street.model.edge.BikeWalkableEdge;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.ElevatorEdge;
import org.opentripplanner.street.model.vertex.ElevatorOffboardVertex;
import org.opentripplanner.street.model.vertex.ElevatorOnboardVertex;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.street.search.state.StateEditor;

public class ElevatorAlightEdge
extends Edge
implements BikeWalkableEdge,
ElevatorEdge {
    private final I18NString level;
    private final LineString the_geom;

    public ElevatorAlightEdge(ElevatorOnboardVertex from, ElevatorOffboardVertex to, I18NString level) {
        super(from, to);
        this.level = level;
        Coordinate[] coords = new Coordinate[]{new Coordinate(from.getX(), from.getY()), new Coordinate(to.getX(), to.getY())};
        this.the_geom = GeometryUtils.getGeometryFactory().createLineString(coords);
    }

    @Override
    public String toString() {
        return "ElevatorAlightEdge(" + this.fromv + " -> " + this.tov + ")";
    }

    @Override
    public State traverse(State s0) {
        StateEditor s1 = this.createEditorForDrivingOrWalking(s0, this);
        s1.incrementWeight(1.0);
        return s1.makeState();
    }

    @Override
    public I18NString getName() {
        return this.level;
    }

    @Override
    public boolean hasBogusName() {
        return false;
    }

    @Override
    public LineString getGeometry() {
        return this.the_geom;
    }

    @Override
    public double getDistanceMeters() {
        return 0.0;
    }
}

