/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.server;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.binder.jersey.server.DefaultJerseyTagsProvider;
import io.micrometer.core.instrument.binder.jersey.server.JerseyTagsProvider;
import io.micrometer.core.instrument.binder.jersey.server.MetricsApplicationEventListener;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import jakarta.ws.rs.core.Application;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJsonProvider;
import org.opentripplanner.api.common.OTPExceptionMapper;
import org.opentripplanner.api.configuration.APIEndpoints;
import org.opentripplanner.api.json.JSONObjectMapperProvider;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.standalone.server.CorsFilter;
import org.opentripplanner.standalone.server.EtagRequestFilter;
import org.opentripplanner.standalone.server.VaryRequestFilter;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class OTPWebApplication
extends Application {
    private final Supplier<OtpServerRequestContext> contextProvider;

    public OTPWebApplication(Supplier<OtpServerRequestContext> contextProvider) {
        this.contextProvider = contextProvider;
    }

    public Set<Class<?>> getClasses() {
        HashSet classes = new HashSet(APIEndpoints.listAPIEndpoints());
        classes.addAll(Set.of(CorsFilter.class, EtagRequestFilter.class, VaryRequestFilter.class));
        return classes;
    }

    public Set<Object> getSingletons() {
        HashSet<MetricsApplicationEventListener> singletons = new HashSet<MetricsApplicationEventListener>(List.of(new OTPExceptionMapper(), new JacksonJsonProvider(), new JSONObjectMapperProvider(), this.makeBinder(this.contextProvider), this.getMetricsApplicationEventListener()));
        if (OTPFeature.ActuatorAPI.isOn()) {
            singletons.add((MetricsApplicationEventListener)this.getBoundPrometheusRegistry());
        }
        return singletons;
    }

    public Map<String, Object> getProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("jersey.config.server.tracing.type", Boolean.TRUE);
        props.put("jersey.config.disableAutoDiscovery", Boolean.TRUE);
        return props;
    }

    private Binder makeBinder(final Supplier<OtpServerRequestContext> contextProvider) {
        return new AbstractBinder(){

            protected void configure() {
                this.bindFactory(contextProvider).to(OtpServerRequestContext.class);
            }
        };
    }

    private MetricsApplicationEventListener getMetricsApplicationEventListener() {
        return new MetricsApplicationEventListener((MeterRegistry)Metrics.globalRegistry, (JerseyTagsProvider)new DefaultJerseyTagsProvider(), "http.server.requests", true);
    }

    private Binder getBoundPrometheusRegistry() {
        final PrometheusMeterRegistry prometheusRegistry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);
        Metrics.globalRegistry.add((MeterRegistry)prometheusRegistry);
        return new AbstractBinder(){

            protected void configure() {
                this.bind(prometheusRegistry).to(PrometheusMeterRegistry.class);
            }
        };
    }

    static {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }
}

