/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.configure;

import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import java.util.List;
import javax.inject.Provider;
import org.opentripplanner.astar.spi.TraverseVisitor;
import org.opentripplanner.ext.ridehailing.RideHailingService;
import org.opentripplanner.ext.ridehailing.configure.RideHailingServicesModule;
import org.opentripplanner.ext.ridehailing.configure.RideHailingServicesModule_ServicesFactory;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueSummary;
import org.opentripplanner.raptor.configure.RaptorConfig;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.service.vehiclepositions.VehiclePositionRepository;
import org.opentripplanner.service.vehiclepositions.VehiclePositionService;
import org.opentripplanner.service.vehiclepositions.internal.DefaultVehiclePositionService;
import org.opentripplanner.service.vehiclepositions.internal.DefaultVehiclePositionService_Factory;
import org.opentripplanner.service.vehiclerental.VehicleRentalRepository;
import org.opentripplanner.service.vehiclerental.VehicleRentalService;
import org.opentripplanner.service.vehiclerental.internal.DefaultVehicleRentalService;
import org.opentripplanner.service.vehiclerental.internal.DefaultVehicleRentalService_Factory;
import org.opentripplanner.service.worldenvelope.WorldEnvelopeRepository;
import org.opentripplanner.service.worldenvelope.WorldEnvelopeService;
import org.opentripplanner.service.worldenvelope.internal.DefaultWorldEnvelopeService;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.standalone.config.ConfigModel;
import org.opentripplanner.standalone.config.RouterConfig;
import org.opentripplanner.standalone.config.configure.ConfigModule_ProvideRouterConfigFactory;
import org.opentripplanner.standalone.config.configure.ConfigModule_ProvidesRaptorConfigFactory;
import org.opentripplanner.standalone.configure.ConstructApplicationFactory;
import org.opentripplanner.standalone.configure.ConstructApplicationModule;
import org.opentripplanner.standalone.configure.ConstructApplicationModule_ProvidesServerContextFactory;
import org.opentripplanner.standalone.server.MetricsLogging;
import org.opentripplanner.transit.service.DefaultTransitService;
import org.opentripplanner.transit.service.TransitModel;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.visualizer.GraphVisualizer;

@DaggerGenerated
public final class DaggerConstructApplicationFactory {
    private DaggerConstructApplicationFactory() {
    }

    public static ConstructApplicationFactory.Builder builder() {
        return new Builder();
    }

    private static final class Builder
    implements ConstructApplicationFactory.Builder {
        private ConfigModel configModel;
        private Graph graph;
        private TransitModel transitModel;
        private GraphVisualizer graphVisualizer;
        private WorldEnvelopeRepository worldEnvelopeRepository;
        private DataImportIssueSummary dataImportIssueSummary;

        private Builder() {
        }

        @Override
        public Builder configModel(ConfigModel config) {
            this.configModel = (ConfigModel)Preconditions.checkNotNull((Object)config);
            return this;
        }

        @Override
        public Builder graph(Graph graph) {
            this.graph = (Graph)Preconditions.checkNotNull((Object)graph);
            return this;
        }

        @Override
        public Builder transitModel(TransitModel transitModel) {
            this.transitModel = (TransitModel)Preconditions.checkNotNull((Object)transitModel);
            return this;
        }

        @Override
        public Builder graphVisualizer(GraphVisualizer graphVisualizer) {
            this.graphVisualizer = graphVisualizer;
            return this;
        }

        @Override
        public Builder worldEnvelopeRepository(WorldEnvelopeRepository worldEnvelopeRepository) {
            this.worldEnvelopeRepository = (WorldEnvelopeRepository)Preconditions.checkNotNull((Object)worldEnvelopeRepository);
            return this;
        }

        @Override
        public Builder dataImportIssueSummary(DataImportIssueSummary issueSummary) {
            this.dataImportIssueSummary = (DataImportIssueSummary)Preconditions.checkNotNull((Object)issueSummary);
            return this;
        }

        @Override
        public ConstructApplicationFactory build() {
            Preconditions.checkBuilderRequirement((Object)this.configModel, ConfigModel.class);
            Preconditions.checkBuilderRequirement((Object)this.graph, Graph.class);
            Preconditions.checkBuilderRequirement((Object)this.transitModel, TransitModel.class);
            Preconditions.checkBuilderRequirement((Object)this.worldEnvelopeRepository, WorldEnvelopeRepository.class);
            Preconditions.checkBuilderRequirement((Object)this.dataImportIssueSummary, DataImportIssueSummary.class);
            return new ConstructApplicationFactoryImpl(new ConstructApplicationModule(), new RideHailingServicesModule(), this.configModel, this.graph, this.transitModel, this.graphVisualizer, this.worldEnvelopeRepository, this.dataImportIssueSummary);
        }
    }

    private static final class ConstructApplicationFactoryImpl
    implements ConstructApplicationFactory {
        private final ConfigModel configModel;
        private final Graph graph;
        private final TransitModel transitModel;
        private final WorldEnvelopeRepository worldEnvelopeRepository;
        private final DataImportIssueSummary dataImportIssueSummary;
        private final GraphVisualizer graphVisualizer;
        private final ConstructApplicationModule constructApplicationModule;
        private final ConstructApplicationFactoryImpl constructApplicationFactoryImpl = this;
        private Provider<ConfigModel> configModelProvider;
        private Provider<RaptorConfig<TripSchedule>> providesRaptorConfigProvider;
        private Provider<DefaultVehiclePositionService> defaultVehiclePositionServiceProvider;
        private Provider<DefaultVehicleRentalService> defaultVehicleRentalServiceProvider;
        private Provider<RouterConfig> provideRouterConfigProvider;
        private Provider<List<RideHailingService>> servicesProvider;

        private ConstructApplicationFactoryImpl(ConstructApplicationModule constructApplicationModuleParam, RideHailingServicesModule rideHailingServicesModuleParam, ConfigModel configModelParam, Graph graphParam, TransitModel transitModelParam, GraphVisualizer graphVisualizerParam, WorldEnvelopeRepository worldEnvelopeRepositoryParam, DataImportIssueSummary dataImportIssueSummaryParam) {
            this.configModel = configModelParam;
            this.graph = graphParam;
            this.transitModel = transitModelParam;
            this.worldEnvelopeRepository = worldEnvelopeRepositoryParam;
            this.dataImportIssueSummary = dataImportIssueSummaryParam;
            this.graphVisualizer = graphVisualizerParam;
            this.constructApplicationModule = constructApplicationModuleParam;
            this.initialize(constructApplicationModuleParam, rideHailingServicesModuleParam, configModelParam, graphParam, transitModelParam, graphVisualizerParam, worldEnvelopeRepositoryParam, dataImportIssueSummaryParam);
        }

        private DefaultWorldEnvelopeService defaultWorldEnvelopeService() {
            return new DefaultWorldEnvelopeService(this.worldEnvelopeRepository);
        }

        private DefaultTransitService defaultTransitService() {
            return new DefaultTransitService(this.transitModel);
        }

        private RouterConfig routerConfig() {
            return ConfigModule_ProvideRouterConfigFactory.provideRouterConfig(this.configModel);
        }

        private TraverseVisitor<?, ?> traverseVisitorOfAnd() {
            return this.constructApplicationModule.traverseVisitor(this.graphVisualizer);
        }

        private void initialize(ConstructApplicationModule constructApplicationModuleParam, RideHailingServicesModule rideHailingServicesModuleParam, ConfigModel configModelParam, Graph graphParam, TransitModel transitModelParam, GraphVisualizer graphVisualizerParam, WorldEnvelopeRepository worldEnvelopeRepositoryParam, DataImportIssueSummary dataImportIssueSummaryParam) {
            this.configModelProvider = InstanceFactory.create((Object)configModelParam);
            this.providesRaptorConfigProvider = DoubleCheck.provider((Provider)ConfigModule_ProvidesRaptorConfigFactory.create(this.configModelProvider));
            this.defaultVehiclePositionServiceProvider = DoubleCheck.provider((Provider)DefaultVehiclePositionService_Factory.create());
            this.defaultVehicleRentalServiceProvider = DoubleCheck.provider((Provider)DefaultVehicleRentalService_Factory.create());
            this.provideRouterConfigProvider = ConfigModule_ProvideRouterConfigFactory.create(this.configModelProvider);
            this.servicesProvider = DoubleCheck.provider((Provider)RideHailingServicesModule_ServicesFactory.create(rideHailingServicesModuleParam, this.provideRouterConfigProvider));
        }

        @Override
        public ConfigModel config() {
            return this.configModel;
        }

        @Override
        public RaptorConfig<TripSchedule> raptorConfig() {
            return (RaptorConfig)this.providesRaptorConfigProvider.get();
        }

        @Override
        public Graph graph() {
            return this.graph;
        }

        @Override
        public TransitModel transitModel() {
            return this.transitModel;
        }

        @Override
        public WorldEnvelopeRepository worldEnvelopeRepository() {
            return this.worldEnvelopeRepository;
        }

        @Override
        public WorldEnvelopeService worldEnvelopeService() {
            return this.defaultWorldEnvelopeService();
        }

        @Override
        public VehiclePositionRepository vehiclePositionRepository() {
            return (VehiclePositionRepository)this.defaultVehiclePositionServiceProvider.get();
        }

        @Override
        public VehiclePositionService vehiclePositionService() {
            return (VehiclePositionService)this.defaultVehiclePositionServiceProvider.get();
        }

        @Override
        public VehicleRentalRepository vehicleRentalRepository() {
            return (VehicleRentalRepository)this.defaultVehicleRentalServiceProvider.get();
        }

        @Override
        public VehicleRentalService vehicleRentalService() {
            return (VehicleRentalService)this.defaultVehicleRentalServiceProvider.get();
        }

        @Override
        public DataImportIssueSummary dataImportIssueSummary() {
            return this.dataImportIssueSummary;
        }

        @Override
        public GraphVisualizer graphVisualizer() {
            return this.graphVisualizer;
        }

        @Override
        public TransitService transitService() {
            return this.defaultTransitService();
        }

        @Override
        public OtpServerRequestContext createServerContext() {
            return ConstructApplicationModule_ProvidesServerContextFactory.providesServerContext(this.constructApplicationModule, this.routerConfig(), (RaptorConfig)this.providesRaptorConfigProvider.get(), this.graph, this.defaultTransitService(), this.defaultWorldEnvelopeService(), (VehiclePositionService)this.defaultVehiclePositionServiceProvider.get(), (VehicleRentalService)this.defaultVehicleRentalServiceProvider.get(), (List)this.servicesProvider.get(), this.traverseVisitorOfAnd());
        }

        @Override
        public MetricsLogging metricsLogging() {
            return new MetricsLogging(this.transitModel, (RaptorConfig)this.providesRaptorConfigProvider.get(), this.dataImportIssueSummary);
        }
    }
}

