/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.configure;

import jakarta.ws.rs.core.Application;
import java.util.List;
import javax.annotation.Nullable;
import org.opentripplanner.datastore.api.DataSource;
import org.opentripplanner.ext.geocoder.LuceneIndex;
import org.opentripplanner.ext.transmodelapi.TransmodelAPI;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.framework.logging.ProgressTracker;
import org.opentripplanner.graph_builder.GraphBuilder;
import org.opentripplanner.graph_builder.GraphBuilderDataSources;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueSummary;
import org.opentripplanner.raptor.configure.RaptorConfig;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TransitLayer;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TransitTuningParameters;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.TripSchedule;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.TransitLayerMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.TransitLayerUpdater;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.service.vehiclepositions.VehiclePositionRepository;
import org.opentripplanner.service.vehiclerental.VehicleRentalRepository;
import org.opentripplanner.service.worldenvelope.WorldEnvelopeRepository;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.standalone.config.BuildConfig;
import org.opentripplanner.standalone.config.CommandLineParameters;
import org.opentripplanner.standalone.config.ConfigModel;
import org.opentripplanner.standalone.config.OtpConfig;
import org.opentripplanner.standalone.config.RouterConfig;
import org.opentripplanner.standalone.configure.ConstructApplicationFactory;
import org.opentripplanner.standalone.configure.DaggerConstructApplicationFactory;
import org.opentripplanner.standalone.server.GrizzlyServer;
import org.opentripplanner.standalone.server.OTPWebApplication;
import org.opentripplanner.street.model.elevation.ElevationUtils;
import org.opentripplanner.transit.service.TransitModel;
import org.opentripplanner.updater.configure.UpdaterConfigurator;
import org.opentripplanner.visualizer.GraphVisualizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstructApplication {
    private static final Logger LOG = LoggerFactory.getLogger(ConstructApplication.class);
    private final CommandLineParameters cli;
    private final GraphBuilderDataSources graphBuilderDataSources;
    private final ConstructApplicationFactory factory;

    ConstructApplication(CommandLineParameters cli, Graph graph, TransitModel transitModel, WorldEnvelopeRepository worldEnvelopeRepository, ConfigModel config, GraphBuilderDataSources graphBuilderDataSources, DataImportIssueSummary issueSummary) {
        this.cli = cli;
        this.graphBuilderDataSources = graphBuilderDataSources;
        GraphVisualizer graphVisualizer = cli.visualize ? new GraphVisualizer(graph) : null;
        this.factory = DaggerConstructApplicationFactory.builder().configModel(config).graph(graph).transitModel(transitModel).graphVisualizer(graphVisualizer).worldEnvelopeRepository(worldEnvelopeRepository).dataImportIssueSummary(issueSummary).build();
    }

    public ConstructApplicationFactory getFactory() {
        return this.factory;
    }

    public GrizzlyServer createGrizzlyServer() {
        return new GrizzlyServer(this.cli, this.createApplication());
    }

    public GraphBuilder createGraphBuilder() {
        LOG.info("Wiring up and configuring graph builder task.");
        return GraphBuilder.create(this.buildConfig(), this.graphBuilderDataSources, this.graph(), this.transitModel(), this.factory.worldEnvelopeRepository(), this.cli.doLoadStreetGraph(), this.cli.doSaveStreetGraph());
    }

    @Nullable
    public DataSource graphOutputDataSource() {
        return this.graphBuilderDataSources.getOutputGraph();
    }

    private Application createApplication() {
        LOG.info("Wiring up and configuring server.");
        this.setupTransitRoutingServer();
        return new OTPWebApplication(this::createServerContext);
    }

    private void setupTransitRoutingServer() {
        this.factory.metricsLogging();
        ConstructApplication.creatTransitLayerForRaptor(this.transitModel(), this.routerConfig().transitTuningConfig());
        UpdaterConfigurator.configure(this.graph(), this.vehiclePositionRepository(), this.vehicleRentalRepository(), this.transitModel(), this.routerConfig().updaterConfig());
        this.initEllipsoidToGeoidDifference();
        ConstructApplication.initializeTransferCache(this.routerConfig().transitTuningConfig(), this.transitModel());
        if (OTPFeature.SandboxAPITransmodelApi.isOn()) {
            TransmodelAPI.setUp(this.routerConfig().transmodelApi(), this.transitModel(), this.routerConfig().routingRequestDefaults());
        }
        if (OTPFeature.SandboxAPIGeocoder.isOn()) {
            LOG.info("Creating debug client geocoder lucene index");
            LuceneIndex.forServer(this.createServerContext());
        }
    }

    private void initEllipsoidToGeoidDifference() {
        try {
            WgsCoordinate c = this.factory.worldEnvelopeService().envelope().orElseThrow().center();
            double value = ElevationUtils.computeEllipsoidToGeoidDifference(c.latitude(), c.longitude());
            this.graph().initEllipsoidToGeoidDifference(value, c.latitude(), c.longitude());
        }
        catch (Exception e) {
            LOG.error("Error computing ellipsoid/geoid difference");
        }
    }

    public static void creatTransitLayerForRaptor(TransitModel transitModel, TransitTuningParameters tuningParameters) {
        if (!transitModel.hasTransit() || transitModel.getTransitModelIndex() == null) {
            LOG.warn("Cannot create Raptor data, that requires the graph to have transit data and be indexed.");
        }
        LOG.info("Creating transit layer for Raptor routing.");
        transitModel.setTransitLayer(TransitLayerMapper.map(tuningParameters, transitModel));
        transitModel.setRealtimeTransitLayer(new TransitLayer(transitModel.getTransitLayer()));
        transitModel.setTransitLayerUpdater(new TransitLayerUpdater(transitModel, transitModel.getTransitModelIndex().getServiceCodesRunningForDate()));
    }

    public static void initializeTransferCache(TransitTuningParameters transitTuningConfig, TransitModel transitModel) {
        List<RouteRequest> transferCacheRequests = transitTuningConfig.transferCacheRequests();
        if (!transferCacheRequests.isEmpty()) {
            ProgressTracker progress = ProgressTracker.track("Creating initial raptor transfer cache", 1, transferCacheRequests.size());
            LOG.info(progress.startMessage());
            transferCacheRequests.forEach(request -> {
                transitModel.getTransitLayer().getRaptorTransfersForRequest((RouteRequest)request);
                progress.step(s -> LOG.info(s));
            });
            LOG.info(progress.completeMessage());
        }
    }

    public TransitModel transitModel() {
        return this.factory.transitModel();
    }

    public DataImportIssueSummary dataImportIssueSummary() {
        return this.factory.dataImportIssueSummary();
    }

    public VehiclePositionRepository vehiclePositionRepository() {
        return this.factory.vehiclePositionRepository();
    }

    public VehicleRentalRepository vehicleRentalRepository() {
        return this.factory.vehicleRentalRepository();
    }

    public Graph graph() {
        return this.factory.graph();
    }

    public WorldEnvelopeRepository worldEnvelopeRepository() {
        return this.factory.worldEnvelopeRepository();
    }

    public OtpConfig otpConfig() {
        return this.factory.config().otpConfig();
    }

    public RouterConfig routerConfig() {
        return this.factory.config().routerConfig();
    }

    public BuildConfig buildConfig() {
        return this.factory.config().buildConfig();
    }

    public RaptorConfig<TripSchedule> raptorConfig() {
        return this.factory.raptorConfig();
    }

    public GraphVisualizer graphVisualizer() {
        return this.factory.graphVisualizer();
    }

    private OtpServerRequestContext createServerContext() {
        return this.factory.createServerContext();
    }
}

