/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.routerconfig.updaters.sources;

import org.opentripplanner.ext.smoovebikerental.SmooveBikeRentalDataSourceParameters;
import org.opentripplanner.ext.vilkkubikerental.VilkkuBikeRentalDataSourceParameters;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;
import org.opentripplanner.standalone.config.routerconfig.updaters.HttpHeadersConfig;
import org.opentripplanner.updater.spi.HttpHeaders;
import org.opentripplanner.updater.vehicle_rental.VehicleRentalSourceType;
import org.opentripplanner.updater.vehicle_rental.datasources.params.GbfsVehicleRentalDataSourceParameters;
import org.opentripplanner.updater.vehicle_rental.datasources.params.VehicleRentalDataSourceParameters;

public class VehicleRentalSourceFactory {
    private final VehicleRentalSourceType type;
    private final NodeAdapter c;

    public VehicleRentalSourceFactory(VehicleRentalSourceType type, NodeAdapter c) {
        this.type = type;
        this.c = c;
    }

    public static VehicleRentalDataSourceParameters create(VehicleRentalSourceType type, NodeAdapter c) {
        return new VehicleRentalSourceFactory(type, c).create();
    }

    public VehicleRentalDataSourceParameters create() {
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case VehicleRentalSourceType.GBFS -> new GbfsVehicleRentalDataSourceParameters(this.url(), this.language(), this.allowKeepingRentedVehicleAtDestination(), this.headers(), this.network(), this.geofencingZones(), this.overloadingAllowed());
            case VehicleRentalSourceType.SMOOVE -> new SmooveBikeRentalDataSourceParameters(this.url(), this.network(), this.overloadingAllowed(), this.headers());
            case VehicleRentalSourceType.VILKKU -> new VilkkuBikeRentalDataSourceParameters(this.url(), this.network(), this.overloadingAllowed(), this.headers());
        };
    }

    private String language() {
        return this.c.of("language").since(OtpVersion.V2_1).summary("TODO").asString(null);
    }

    private HttpHeaders headers() {
        return HttpHeadersConfig.headers(this.c, OtpVersion.V1_5);
    }

    private String url() {
        return this.c.of("url").since(OtpVersion.V1_5).summary("The URL to download the data from.").asString();
    }

    private String network() {
        return this.c.of("network").since(OtpVersion.V1_5).summary("The name of the network to override the one derived from the source data.").description("GBFS feeds must include a system_id which will be used as the default `network`. These ids are sometimes not helpful so setting this property will override it.").asString(null);
    }

    private boolean allowKeepingRentedVehicleAtDestination() {
        return this.c.of("allowKeepingRentedBicycleAtDestination").since(OtpVersion.V2_1).summary("If a vehicle should be allowed to be kept at the end of a station-based rental.").description("In some cases it may be useful to not drop off the rented bicycle before arriving at the destination.\nThis is useful if bicycles may only be rented for round trips, or the destination is an intermediate place.\n\nFor this to be possible three things need to be configured:\n\n - In the updater configuration `allowKeepingRentedBicycleAtDestination` should be set to `true`.\n - `allowKeepingRentedBicycleAtDestination` should also be set for each request, either using routing defaults, or per-request.\n - If keeping the bicycle at the destination should be discouraged, then `keepingRentedBicycleAtDestinationCost` (default: 0) may also be set in the routing defaults.\n").asBoolean(false);
    }

    private boolean overloadingAllowed() {
        return this.c.of("overloadingAllowed").since(OtpVersion.V2_2).summary("Allow leaving vehicles at a station even though there are no free slots.").asBoolean(false);
    }

    private boolean geofencingZones() {
        return this.c.of("geofencingZones").since(OtpVersion.V2_3).summary("Compute rental restrictions based on GBFS 2.2 geofencing zones.").description("This feature is somewhat experimental and therefore turned off by default for the following reasons:\n\n- It delays start up of OTP. How long is dependent on the complexity of the zones. For example in Oslo it takes 6 seconds to compute while Portland takes 25 seconds.\n- It's easy for a malformed or unintended geofencing zone to make routing impossible. If you encounter such a case, please file a bug report.\n").asBoolean(false);
    }
}

