/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.routerconfig.updaters;

import java.net.URI;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;
import org.opentripplanner.standalone.config.routerconfig.updaters.HttpHeadersConfig;
import org.opentripplanner.updater.spi.HttpHeaders;
import org.opentripplanner.updater.vehicle_position.VehiclePositionsUpdaterParameters;

public class VehiclePositionsUpdaterConfig {
    public static VehiclePositionsUpdaterParameters create(String updaterRef, NodeAdapter c) {
        String feedId = c.of("feedId").since(OtpVersion.V2_2).summary("Feed ID to which the update should be applied.").asString();
        int frequencySec = c.of("frequencySec").since(OtpVersion.V2_2).summary("How often the positions should be updated.").asInt(60);
        URI url = c.of("url").since(OtpVersion.V2_2).summary("The URL of GTFS-RT protobuf HTTP resource to download the positions from.").asUri();
        HttpHeaders headers = HttpHeadersConfig.headers(c, OtpVersion.V2_3);
        return new VehiclePositionsUpdaterParameters(updaterRef, feedId, url, frequencySec, headers);
    }
}

