/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.routerconfig;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.opentripplanner.ext.siri.updater.SiriETGooglePubsubUpdaterParameters;
import org.opentripplanner.ext.siri.updater.SiriETUpdaterParameters;
import org.opentripplanner.ext.siri.updater.SiriSXUpdaterParameters;
import org.opentripplanner.ext.siri.updater.azure.SiriAzureETUpdaterParameters;
import org.opentripplanner.ext.siri.updater.azure.SiriAzureSXUpdaterParameters;
import org.opentripplanner.ext.vehiclerentalservicedirectory.api.VehicleRentalServiceDirectoryFetcherParameters;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;
import org.opentripplanner.standalone.config.routerconfig.updaters.GtfsRealtimeAlertsUpdaterConfig;
import org.opentripplanner.standalone.config.routerconfig.updaters.MqttGtfsRealtimeUpdaterConfig;
import org.opentripplanner.standalone.config.routerconfig.updaters.PollingTripUpdaterConfig;
import org.opentripplanner.standalone.config.routerconfig.updaters.SiriETGooglePubsubUpdaterConfig;
import org.opentripplanner.standalone.config.routerconfig.updaters.SiriETUpdaterConfig;
import org.opentripplanner.standalone.config.routerconfig.updaters.SiriSXUpdaterConfig;
import org.opentripplanner.standalone.config.routerconfig.updaters.VehicleParkingUpdaterConfig;
import org.opentripplanner.standalone.config.routerconfig.updaters.VehiclePositionsUpdaterConfig;
import org.opentripplanner.standalone.config.routerconfig.updaters.VehicleRentalUpdaterConfig;
import org.opentripplanner.standalone.config.routerconfig.updaters.WFSNotePollingGraphUpdaterConfig;
import org.opentripplanner.standalone.config.routerconfig.updaters.WebsocketGtfsRealtimeUpdaterConfig;
import org.opentripplanner.standalone.config.routerconfig.updaters.azure.SiriAzureETUpdaterConfig;
import org.opentripplanner.standalone.config.routerconfig.updaters.azure.SiriAzureSXUpdaterConfig;
import org.opentripplanner.standalone.config.sandbox.VehicleRentalServiceDirectoryFetcherConfig;
import org.opentripplanner.updater.TimetableSnapshotSourceParameters;
import org.opentripplanner.updater.UpdatersParameters;
import org.opentripplanner.updater.alert.GtfsRealtimeAlertsUpdaterParameters;
import org.opentripplanner.updater.street_note.WFSNotePollingGraphUpdaterParameters;
import org.opentripplanner.updater.trip.MqttGtfsRealtimeUpdaterParameters;
import org.opentripplanner.updater.trip.PollingTripUpdaterParameters;
import org.opentripplanner.updater.trip.WebsocketGtfsRealtimeUpdaterParameters;
import org.opentripplanner.updater.vehicle_parking.VehicleParkingUpdaterParameters;
import org.opentripplanner.updater.vehicle_position.VehiclePositionsUpdaterParameters;
import org.opentripplanner.updater.vehicle_rental.VehicleRentalUpdaterParameters;

public class UpdatersConfig
implements UpdatersParameters {
    private final Multimap<Type, Object> configList = ArrayListMultimap.create();
    private final TimetableSnapshotSourceParameters timetableUpdates;
    @Nullable
    private final VehicleRentalServiceDirectoryFetcherParameters vehicleRentalServiceDirectoryFetcherParameters;

    public UpdatersConfig(NodeAdapter rootAdapter) {
        this.vehicleRentalServiceDirectoryFetcherParameters = VehicleRentalServiceDirectoryFetcherConfig.create("vehicleRentalServiceDirectory", rootAdapter);
        this.timetableUpdates = this.timetableUpdates(rootAdapter.of("timetableUpdates").since(OtpVersion.V2_2).summary("Global configuration for timetable updaters.").asObject());
        rootAdapter.of("updaters").since(OtpVersion.V1_5).summary("Configuration for the updaters that import various types of data into OTP.").asObjects(it -> {
            Type type = (Type)((Object)((Object)it.of("type").since(OtpVersion.V1_5).summary("The type of the updater.").asEnum(Type.class)));
            Object config = type.parseConfig((NodeAdapter)it);
            this.configList.put((Object)type, config);
            return config;
        });
    }

    private TimetableSnapshotSourceParameters timetableUpdates(NodeAdapter c) {
        TimetableSnapshotSourceParameters dflt = TimetableSnapshotSourceParameters.DEFAULT;
        if (c.isEmpty()) {
            return dflt;
        }
        return new TimetableSnapshotSourceParameters(c.of("maxSnapshotFrequency").since(OtpVersion.V2_2).summary("How long a snapshot should be cached.").description("If a timetable snapshot is requested less than this number of milliseconds after the previous snapshot, then return the same instance. Throttles the potentially resource-consuming task of duplicating a TripPattern \u2192 Timetable map and indexing the new Timetables. Applies to GTFS-RT and Siri updates.").asDuration(dflt.maxSnapshotFrequency()), c.of("purgeExpiredData").since(OtpVersion.V2_2).summary("Should expired realtime data be purged from the graph. Apply to GTFS-RT and Siri updates.").asBoolean(dflt.purgeExpiredData()));
    }

    @Override
    public TimetableSnapshotSourceParameters timetableSnapshotParameters() {
        return this.timetableUpdates;
    }

    @Override
    @Nullable
    public VehicleRentalServiceDirectoryFetcherParameters getVehicleRentalServiceDirectoryFetcherParameters() {
        return this.vehicleRentalServiceDirectoryFetcherParameters;
    }

    @Override
    public List<VehicleRentalUpdaterParameters> getVehicleRentalParameters() {
        ArrayList<VehicleRentalUpdaterParameters> result = new ArrayList<VehicleRentalUpdaterParameters>(this.getParameters(Type.VEHICLE_RENTAL));
        result.addAll(this.getParameters(Type.BIKE_RENTAL));
        return result;
    }

    @Override
    public List<GtfsRealtimeAlertsUpdaterParameters> getGtfsRealtimeAlertsUpdaterParameters() {
        return this.getParameters(Type.REAL_TIME_ALERTS);
    }

    @Override
    public List<PollingTripUpdaterParameters> getPollingStoptimeUpdaterParameters() {
        return this.getParameters(Type.STOP_TIME_UPDATER);
    }

    @Override
    public List<VehiclePositionsUpdaterParameters> getVehiclePositionsUpdaterParameters() {
        return this.getParameters(Type.VEHICLE_POSITIONS);
    }

    @Override
    public List<SiriETUpdaterParameters> getSiriETUpdaterParameters() {
        return this.getParameters(Type.SIRI_ET_UPDATER);
    }

    @Override
    public List<SiriETGooglePubsubUpdaterParameters> getSiriETGooglePubsubUpdaterParameters() {
        return this.getParameters(Type.SIRI_ET_GOOGLE_PUBSUB_UPDATER);
    }

    @Override
    public List<SiriSXUpdaterParameters> getSiriSXUpdaterParameters() {
        return this.getParameters(Type.SIRI_SX_UPDATER);
    }

    @Override
    public List<WebsocketGtfsRealtimeUpdaterParameters> getWebsocketGtfsRealtimeUpdaterParameters() {
        return this.getParameters(Type.WEBSOCKET_GTFS_RT_UPDATER);
    }

    @Override
    public List<MqttGtfsRealtimeUpdaterParameters> getMqttGtfsRealtimeUpdaterParameters() {
        return this.getParameters(Type.MQTT_GTFS_RT_UPDATER);
    }

    @Override
    public List<VehicleParkingUpdaterParameters> getVehicleParkingUpdaterParameters() {
        return this.getParameters(Type.VEHICLE_PARKING);
    }

    @Override
    public List<WFSNotePollingGraphUpdaterParameters> getWinkkiPollingGraphUpdaterParameters() {
        return this.getParameters(Type.WINKKI_POLLING_UPDATER);
    }

    @Override
    public List<SiriAzureETUpdaterParameters> getSiriAzureETUpdaterParameters() {
        return this.getParameters(Type.SIRI_AZURE_ET_UPDATER);
    }

    @Override
    public List<SiriAzureSXUpdaterParameters> getSiriAzureSXUpdaterParameters() {
        return this.getParameters(Type.SIRI_AZURE_SX_UPDATER);
    }

    private <T> List<T> getParameters(Type key) {
        return (List)this.configList.get((Object)key);
    }

    public static enum Type {
        BIKE_PARK(VehicleParkingUpdaterConfig::create),
        VEHICLE_PARKING(VehicleParkingUpdaterConfig::create),
        BIKE_RENTAL(VehicleRentalUpdaterConfig::create),
        VEHICLE_RENTAL(VehicleRentalUpdaterConfig::create),
        STOP_TIME_UPDATER(PollingTripUpdaterConfig::create),
        WEBSOCKET_GTFS_RT_UPDATER(WebsocketGtfsRealtimeUpdaterConfig::create),
        MQTT_GTFS_RT_UPDATER(MqttGtfsRealtimeUpdaterConfig::create),
        REAL_TIME_ALERTS(GtfsRealtimeAlertsUpdaterConfig::create),
        VEHICLE_POSITIONS(VehiclePositionsUpdaterConfig::create),
        WINKKI_POLLING_UPDATER(WFSNotePollingGraphUpdaterConfig::create),
        SIRI_ET_UPDATER(SiriETUpdaterConfig::create),
        SIRI_ET_GOOGLE_PUBSUB_UPDATER(SiriETGooglePubsubUpdaterConfig::create),
        SIRI_SX_UPDATER(SiriSXUpdaterConfig::create),
        SIRI_AZURE_ET_UPDATER(SiriAzureETUpdaterConfig::create),
        SIRI_AZURE_SX_UPDATER(SiriAzureSXUpdaterConfig::create);

        private final BiFunction<String, NodeAdapter, ?> factory;

        private Type(BiFunction<String, NodeAdapter, ?> factory) {
            this.factory = factory;
        }

        Object parseConfig(NodeAdapter nodeAdapter) {
            return this.factory.apply(this.name(), nodeAdapter);
        }
    }
}

