/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.routerconfig;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.function.Function;
import org.opentripplanner.ext.ridehailing.RideHailingServiceParameters;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;
import org.opentripplanner.standalone.config.routerconfig.services.UberConfig;

public class RideHailingServicesConfig {
    private final Multimap<Type, Object> configList = ArrayListMultimap.create();

    public RideHailingServicesConfig(NodeAdapter rootAdapter) {
        rootAdapter.of("rideHailingServices").since(OtpVersion.V2_3).summary("Configuration for interfaces to external ride hailing services like Uber.").asObjects(it -> {
            Type type = (Type)((Object)((Object)it.of("type").since(OtpVersion.V2_3).summary("The type of the service.").asEnum(Type.class)));
            Object config = type.parseConfig((NodeAdapter)it);
            this.configList.put((Object)type, config);
            return config;
        });
    }

    public List<RideHailingServiceParameters> rideHailingServiceParameters() {
        return this.configList.values().stream().filter(RideHailingServiceParameters.class::isInstance).map(RideHailingServiceParameters.class::cast).toList();
    }

    public static enum Type {
        UBER_CAR_HAILING(UberConfig::create);

        private final Function<NodeAdapter, ?> factory;

        private Type(Function<NodeAdapter, ?> factory) {
            this.factory = factory;
        }

        Object parseConfig(NodeAdapter nodeAdapter) {
            return this.factory.apply(nodeAdapter);
        }
    }
}

