/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config.buildconfig;

import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;

public class IslandPruningConfig {
    public int pruningThresholdIslandWithoutStops;
    public int pruningThresholdIslandWithStops;
    public int adaptivePruningDistance;
    public double adaptivePruningFactor;

    public static IslandPruningConfig fromConfig(NodeAdapter root) {
        return IslandPruningConfig.fromSubConfig(root.of("islandPruning").since(OtpVersion.V2_3).summary("Settings for fixing street graph connectivity errors").asObject());
    }

    public static IslandPruningConfig fromSubConfig(NodeAdapter config) {
        IslandPruningConfig islandPruning = new IslandPruningConfig();
        islandPruning.pruningThresholdIslandWithStops = config.of("islandWithStopsMaxSize").since(OtpVersion.V2_3).summary("When a graph island with stops in it should be pruned.").description("This field indicates the pruning threshold for islands with stops. Any such island under this\nedge count will be pruned.\n").asInt(2);
        islandPruning.pruningThresholdIslandWithoutStops = config.of("islandWithoutStopsMaxSize").since(OtpVersion.V2_3).summary("When a graph island without stops should be pruned.").description("This field indicates the pruning threshold for islands without stops. Any such island under\nthis edge count will be pruned.\n").asInt(10);
        islandPruning.adaptivePruningDistance = config.of("adaptivePruningDistance").since(OtpVersion.V2_3).summary("Search distance for analyzing islands in pruning.").description("The distance after which disconnected sub graph is considered as real island in pruning heuristics.\n").asInt(250);
        islandPruning.adaptivePruningFactor = config.of("adaptivePruningFactor").since(OtpVersion.V2_3).summary("Defines how much pruning thresholds grow maximally by distance.").description("Expands the pruning thresholds as the distance of an island from the rest of the graph gets smaller.\nEven fairly large disconnected sub graphs should be removed if they are badly entangled with other graph.\n").asDouble(50.0);
        return islandPruning;
    }
}

