/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import javax.annotation.Nullable;
import org.opentripplanner.standalone.config.BuildConfig;
import org.opentripplanner.standalone.config.OtpConfig;
import org.opentripplanner.standalone.config.RouterConfig;
import org.opentripplanner.standalone.config.framework.file.ConfigFileLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtpConfigLoader {
    private static final Logger LOG = LoggerFactory.getLogger(OtpConfigLoader.class);
    @Nullable
    private final File configDir;
    @Nullable
    private final String jsonFallback;

    private OtpConfigLoader(File configDir, String jsonFallback) {
        this.configDir = configDir;
        this.jsonFallback = jsonFallback;
    }

    public OtpConfigLoader(File configDir) {
        this(configDir, null);
    }

    public static OtpConfigLoader fromString(String json) {
        return new OtpConfigLoader(null, json);
    }

    public static void logConfigVersion(String otpConfigVersion, String buildConfigVersion, String routerConfigVersion) {
        OtpConfigLoader.logConfigVersion(otpConfigVersion, "otp-config.json");
        OtpConfigLoader.logConfigVersion(buildConfigVersion, "build-config.json");
        OtpConfigLoader.logConfigVersion(routerConfigVersion, "router-config.json");
    }

    public OtpConfig loadOtpConfig() {
        return new OtpConfig(this.loadFromFile("otp-config.json"), "otp-config.json", true);
    }

    public BuildConfig loadBuildConfig() {
        JsonNode node = this.loadFromFile("build-config.json");
        if (node.isMissingNode()) {
            return BuildConfig.DEFAULT;
        }
        return new BuildConfig(node, "build-config.json", true);
    }

    public RouterConfig loadRouterConfig() {
        JsonNode node = this.loadFromFile("router-config.json");
        if (node.isMissingNode()) {
            return RouterConfig.DEFAULT;
        }
        return new RouterConfig(node, "router-config.json", true);
    }

    private static void logConfigVersion(String configVersion, String filename) {
        if (configVersion != null) {
            LOG.info("{} config-version is {}.", (Object)filename, (Object)configVersion);
        }
    }

    private JsonNode loadFromFile(String filename) {
        return ConfigFileLoader.of().withConfigDir(this.configDir).withJsonFallback(this.jsonFallback).loadFromFile(filename);
    }
}

