/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.standalone.config;

import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.standalone.config.BuildConfig;
import org.opentripplanner.standalone.config.OtpConfig;
import org.opentripplanner.standalone.config.OtpConfigLoader;
import org.opentripplanner.standalone.config.RouterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigModel {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigModel.class);
    private final OtpConfig otpConfig;
    private BuildConfig buildConfig;
    private RouterConfig routerConfig;

    public ConfigModel(OtpConfig otpConfig, BuildConfig buildConfig, RouterConfig routerConfig) {
        this.otpConfig = otpConfig;
        this.buildConfig = buildConfig;
        this.routerConfig = routerConfig;
        ConfigModel.initializeOtpFeatures(otpConfig);
    }

    public ConfigModel(OtpConfigLoader loader) {
        this(loader.loadOtpConfig(), loader.loadBuildConfig(), loader.loadRouterConfig());
    }

    public void updateConfigFromSerializedGraph(BuildConfig buildConfig, RouterConfig routerConfig) {
        if (this.buildConfig.isDefault()) {
            LOG.info("Using the graph embedded JSON build configuration.");
            this.buildConfig = buildConfig;
        }
        if (this.routerConfig.isDefault()) {
            LOG.info("Using the graph embedded JSON router configuration.");
            this.routerConfig = routerConfig;
        }
        OtpConfigLoader.logConfigVersion(this.otpConfig.configVersion, this.buildConfig.configVersion, this.routerConfig.getConfigVersion());
    }

    public OtpConfig otpConfig() {
        return this.otpConfig;
    }

    public BuildConfig buildConfig() {
        return this.buildConfig;
    }

    public RouterConfig routerConfig() {
        return this.routerConfig;
    }

    public static void initializeOtpFeatures(OtpConfig otpConfig) {
        OTPFeature.enableFeatures(otpConfig.otpFeatures);
        OTPFeature.logFeatureSetup();
    }
}

