/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.service.vehiclerental.street;

import java.util.Collections;
import java.util.Set;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalPlace;
import org.opentripplanner.service.vehiclerental.street.VehicleRentalPlaceVertex;
import org.opentripplanner.street.model.RentalFormFactor;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.street.search.state.StateEditor;

public class VehicleRentalEdge
extends Edge {
    public RentalFormFactor formFactor;

    public VehicleRentalEdge(VehicleRentalPlaceVertex vertex, RentalFormFactor formFactor) {
        super(vertex, vertex);
        this.formFactor = formFactor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public State traverse(State s0) {
        boolean pickedUp;
        RoutingPreferences preferences;
        StateEditor s1;
        block26: {
            boolean realtimeAvailability;
            String network;
            VehicleRentalPlace station;
            Set<RentalFormFactor> allowedRentalFormFactors;
            block25: {
                if (!s0.getRequest().mode().includesRenting()) {
                    return null;
                }
                allowedRentalFormFactors = VehicleRentalEdge.allowedModes(s0.getRequest().mode());
                if (!allowedRentalFormFactors.isEmpty() && !allowedRentalFormFactors.contains((Object)this.formFactor)) {
                    return null;
                }
                s1 = s0.edit(this);
                VehicleRentalPlaceVertex stationVertex = (VehicleRentalPlaceVertex)this.tov;
                station = stationVertex.getStation();
                network = station.getNetwork();
                preferences = s0.getPreferences();
                realtimeAvailability = preferences.rental().useAvailabilityInformation();
                if (station.networkIsNotAllowed(s0.getRequest().rental())) {
                    return null;
                }
                if (!s0.getRequest().arriveBy()) break block25;
                switch (s0.getVehicleRentalState()) {
                    case BEFORE_RENTING: {
                        return null;
                    }
                    case HAVE_RENTED: {
                        if (realtimeAvailability && !station.allowDropoffNow() || !station.getAvailableDropoffFormFactors(realtimeAvailability).contains((Object)this.formFactor)) {
                            return null;
                        }
                        s1.dropOffRentedVehicleAtStation(this.formFactor, network, true);
                        pickedUp = false;
                        break block26;
                    }
                    case RENTING_FLOATING: {
                        if (!station.getAvailablePickupFormFactors(realtimeAvailability).contains((Object)this.formFactor)) {
                            return null;
                        }
                        if (!station.isFloatingVehicle()) return null;
                        s1.beginFloatingVehicleRenting(this.formFactor, network, true);
                        pickedUp = true;
                        break block26;
                    }
                    case RENTING_FROM_STATION: {
                        if (realtimeAvailability && !station.allowPickupNow() || !station.getAvailablePickupFormFactors(realtimeAvailability).contains((Object)this.formFactor)) {
                            return null;
                        }
                        if (s0.mayKeepRentedVehicleAtDestination() && !station.isArrivingInRentalVehicleAtDestinationAllowed()) {
                            return null;
                        }
                        if (!this.hasCompatibleNetworks(network, s0.getVehicleRentalNetwork())) {
                            return null;
                        }
                        s1.beginVehicleRentingAtStation(this.formFactor, network, false, true);
                        pickedUp = true;
                        break block26;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            switch (s0.getVehicleRentalState()) {
                case BEFORE_RENTING: {
                    if (realtimeAvailability && !station.allowPickupNow() || !station.getAvailablePickupFormFactors(realtimeAvailability).contains((Object)this.formFactor)) {
                        return null;
                    }
                    if (station.isFloatingVehicle()) {
                        s1.beginFloatingVehicleRenting(this.formFactor, network, false);
                    } else {
                        boolean mayKeep = s0.getRequest().rental().allowArrivingInRentedVehicleAtDestination() && station.isArrivingInRentalVehicleAtDestinationAllowed();
                        s1.beginVehicleRentingAtStation(this.formFactor, network, mayKeep, false);
                    }
                    pickedUp = true;
                    break;
                }
                case HAVE_RENTED: {
                    return null;
                }
                case RENTING_FLOATING: 
                case RENTING_FROM_STATION: {
                    if (!this.hasCompatibleNetworks(network, s0.getVehicleRentalNetwork())) {
                        return null;
                    }
                    Set<RentalFormFactor> formFactors = station.getAvailableDropoffFormFactors(realtimeAvailability);
                    if (realtimeAvailability && !station.allowDropoffNow() || !formFactors.contains((Object)this.formFactor)) {
                        return null;
                    }
                    if (!allowedRentalFormFactors.isEmpty() && Collections.disjoint(allowedRentalFormFactors, formFactors)) {
                        return null;
                    }
                    s1.dropOffRentedVehicleAtStation(this.formFactor, network, false);
                    pickedUp = false;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        s1.incrementWeight(pickedUp ? (double)preferences.rental().pickupCost() : (double)preferences.rental().dropoffCost());
        s1.incrementTimeInSeconds(pickedUp ? preferences.rental().pickupTime() : preferences.rental().dropoffTime());
        s1.setBackMode(null);
        return s1.makeState();
    }

    @Override
    public I18NString getName() {
        return this.getToVertex().getName();
    }

    @Override
    public boolean hasBogusName() {
        return false;
    }

    @Override
    public LineString getGeometry() {
        return null;
    }

    @Override
    public double getDistanceMeters() {
        return 0.0;
    }

    private boolean hasCompatibleNetworks(String stationNetwork, String rentedNetwork) {
        if (rentedNetwork == null) {
            return true;
        }
        return rentedNetwork.equals(stationNetwork);
    }

    private static Set<RentalFormFactor> allowedModes(StreetMode streetMode) {
        return switch (streetMode) {
            case StreetMode.BIKE_RENTAL -> Set.of(RentalFormFactor.BICYCLE, RentalFormFactor.CARGO_BICYCLE);
            case StreetMode.SCOOTER_RENTAL -> Set.of(RentalFormFactor.SCOOTER, RentalFormFactor.SCOOTER_SEATED, RentalFormFactor.SCOOTER_STANDING);
            case StreetMode.CAR_RENTAL -> Set.of(RentalFormFactor.CAR);
            default -> Set.of();
        };
    }
}

