/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.service.vehiclerental.model;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.entur.gbfs.v2_3.vehicle_types.GBFSVehicleType;
import org.opentripplanner.street.model.RentalFormFactor;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public class RentalVehicleType
implements Serializable,
Comparable<RentalVehicleType> {
    static final Map<String, RentalVehicleType> defaultVehicleForSystem = new ConcurrentHashMap<String, RentalVehicleType>();
    public final FeedScopedId id;
    public final String name;
    public final RentalFormFactor formFactor;
    public final PropulsionType propulsionType;
    public final Double maxRangeMeters;

    public RentalVehicleType(FeedScopedId id, String name, RentalFormFactor formFactor, PropulsionType propulsionType, Double maxRangeMeters) {
        this.id = id;
        this.name = name;
        this.formFactor = formFactor;
        this.propulsionType = propulsionType;
        this.maxRangeMeters = maxRangeMeters;
    }

    public static RentalVehicleType getDefaultType(String systemId) {
        return defaultVehicleForSystem.computeIfAbsent(systemId, id -> new RentalVehicleType(new FeedScopedId((String)id, "DEFAULT"), "Default vehicle type", RentalFormFactor.BICYCLE, PropulsionType.HUMAN, null));
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RentalVehicleType that = (RentalVehicleType)o;
        return this.id.equals(that.id);
    }

    @Override
    public int compareTo(RentalVehicleType rentalVehicleType) {
        return this.id.compareTo(rentalVehicleType.id);
    }

    public static enum PropulsionType {
        HUMAN,
        ELECTRIC_ASSIST,
        ELECTRIC,
        COMBUSTION,
        COMBUSTION_DIESEL,
        HYBRID,
        PLUG_IN_HYBRID,
        HYDROGEN_FUEL_CELL;


        public static PropulsionType fromGbfs(GBFSVehicleType.PropulsionType propulsionType) {
            return switch (propulsionType) {
                default -> throw new IncompatibleClassChangeError();
                case GBFSVehicleType.PropulsionType.HUMAN -> HUMAN;
                case GBFSVehicleType.PropulsionType.ELECTRIC_ASSIST -> ELECTRIC_ASSIST;
                case GBFSVehicleType.PropulsionType.ELECTRIC -> ELECTRIC;
                case GBFSVehicleType.PropulsionType.COMBUSTION -> COMBUSTION;
                case GBFSVehicleType.PropulsionType.COMBUSTION_DIESEL -> COMBUSTION_DIESEL;
                case GBFSVehicleType.PropulsionType.HYBRID -> HYBRID;
                case GBFSVehicleType.PropulsionType.PLUG_IN_HYBRID -> PLUG_IN_HYBRID;
                case GBFSVehicleType.PropulsionType.HYDROGEN_FUEL_CELL -> HYDROGEN_FUEL_CELL;
            };
        }
    }
}

